  { St2LM_2.pde }

  { **************************************************************
	
	   2
	   ( )
	    
	(  ).

	  ---     .

	      ,
	 ---  .
	
	   ,
	     .

    *************************************************************** }

  title "  "

  select
    modes =4 	{    }
    errlim=1e-5

  Variables
    U                   { U  V -  }
    V


  definitions
    {  -   }
    h=2e-2      {}
    b=16e-2	{}
    l=5e-2	{ }
    nu = 0.29	{    }
    E  = 2e11 	{     }
    rho = 7.86e3   { }
    mu  = E/2/(1+nu)	{ }
    lambdaL =  2*mu*nu/(1-2*nu)   {. }
	{.      }
    lambdaz = 2*mu*lambdaL/(lambdaL+2*mu)
    Sxx = dx(U)		{  Sxx}
    Syy = dy(V)		{  Syy}
    Sxy = (dy(U)+dx(V))/2	{  Sxy}
    Txx= lambdaz*(Sxx+Syy)+2*mu*Sxx        { Txx}
    Tyy= lambdaz*(Sxx+Syy)+2*mu*Syy       { T}
    Txy=2*mu*Sxy			 { Txy}
    Scal=0.2*globalmax(magnitude(x,y))/globalmax(magnitude(u,v))
    Freq=sqrt(lambda)/(2*pi) { f  }

  equations
	{   
                              }
  u:   dx(Txx) + dy(Txy) + lambda*rho*U  = 0
   v:  dx(Txy) + dy(Tyy) + lambda*rho*V  = 0

  boundaries               {      }
     Region 1        { 1 ---   }
	start (h/2,0)
	natural(U)=0 natural(V)=0    {   }
	line to (h/2,b-h) to (l,b-h) to (l,b)  to (-l,b)
	line to (-l,b-h) to (-h/2,b-h) to (-h/2,0) to close

     Region 2         { 2    }
	{  }
	nu=0.33  E=1.2e11  rho=8.9e3
	start (h/2,0)
	natural(U)=0 natural(V)=0    {   }
	line to (h/2,-b+h) to (l,-b+h) to (l,-b)
	value(U)=0  value(V)=0   {  }
	line to (-l,-b)
	natural(U)=0 natural(V)=0
	line to (-l,-b+h) to (-h/2,-b+h) to (-h/2,0) to close

  monitors
    grid(x+Scal*U,y+Scal*V)  as " "
        report Freq as " "

  plots                                 {   }
    grid(x+Scal*U,y+Scal*V)  as " "
        report Freq as " "

  end


