  { St2LM_3.pde }
  
  { **************************************************************
	
	   3
	   ( )
	    
	( ).


    *************************************************************** }

{  Title ' '}
  
  select
    modes =4 	{    }
    errlim = 1e-2	{  }

  coordinates
    ycylinder('r','z')

  variables
     U      V  

  definitions
    dimy=0.1	{}
    dimx=3*dimy	{}
    dimy2=dimy/2

    nu = 0.29	{    }
    E  = 2e11 	{     }
    rho = 7.86e3   { }
    mu  = E/2/(1+nu)	{ }
    lambdaL =  2*mu*nu/(1-2*nu)   {. }

    Srr = dr(U)
    Stt = if r>0 then U/r else 1
    Szz = dz(V)
    Srz = (dz(U)+dr(V))/2
    trS=Srr+Stt+Szz
    Trr = 2*mu*Srr+lambdaL*trS    { Trr}
    Ttt = 2*mu*Stt+lambdaL*trS     { Ttt}
    Tzz = 2*mu*Szz+lambdaL*trS    { Tzz}
    Trz = 2*mu*Srz		       { Txy}
 
    mcoeff=0.1    {    }
    Scal=mcoeff*globalmax(magnitude(r,z))/globalmax(magnitude(U,V))
    Freq=sqrt(lambda)/(2*pi) { f  }

 initial values
    U = 0
    V = 0

  equations     {      }

     dr(r*Trr)/r-Ttt/r+dz(Trz)+ lambda*rho*U = 0
     dr(r*Trz)/r+dz(Tzz) + lambda*rho*V  = 0
    
  boundaries       {    }
    region 1
      start (0,0)
      value(U)=0
      value(V)=0
      line to (0,dimy2) 
      natural(U)=0
      natural(V)=0
      line to (dimx,dimy2)   to (dimx,0)  to  finish

    region 2 { 2    }
     {  }
     nu=0.33  E=1.2e11  rho=8.9e3
      start (0,dimy2) 
      value(U)=0
      value(V)=0
     line to (0,dimy) 
      natural(U)=0
      natural(V)=0
      line to (dimx,dimy)   to (dimx,dimy2)  to  finish

    monitors  
      grid(r+Scal*U,z+Scal*V)  as " "
        report Freq as " "

    plots                                 {   }
      grid(r+Scal*U,z+Scal*V)  as " "
        report Freq as " "
    
  end 


 
