// пример программы для работы с файлами

#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <unistd.h>

struct data {
    int m_nNum;
    char m_szName[20];
};

int main(int argc, char**argv) {
    int i;

    // Prints arguments
    //printf("Arguments:\n");
    //for (i = 0; i < argc; i++) {
    //    printf("%i: %s\n", i, argv[i]);
    //}


    ssize_t nSize;
    off_t nOffset;
    struct data d1 = {10, "Something"}, d2;
    int nFD = open("files.bin",
            O_RDWR | O_CREAT | O_TRUNC,
            S_IRUSR | S_IWUSR);
    if (nFD == -1) {
        perror("open");
        return EXIT_FAILURE;
    }

    nSize = write(nFD, &d1, sizeof (d1));
    if (nSize < sizeof (d1)) {
        if (nSize == -1)
            perror("write");
        fprintf(stderr, "Could not write all bytes\n");
        close(nFD);
        return EXIT_FAILURE;
    }

    nOffset = lseek(nFD, 0, SEEK_SET);
    if (nOffset == -1) {
        perror("lseek");
        close(nFD);
        return EXIT_FAILURE;
    }

    nSize = read(nFD, &d2, sizeof (d2));
    if (nSize < sizeof (d2)) {
        if (nSize == -1)
            perror("read");
        fprintf(stderr, "Could not read all bytes\n");
        close(nFD);
        return EXIT_FAILURE;
    }
    printf("Num: %d\nName: %s\n", d2.m_nNum, d2.m_szName);
    close(nFD);

    return EXIT_SUCCESS;
}
// main()
