// пример программы работы с файлами, отображаемыми в память

#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <sys/mman.h>
#include <fcntl.h>
#include <unistd.h> 
#include <stdio.h>
#include <stddef.h>

struct data {
    int m_nNum;
    char m_szData[20];
};

int main(int argc, char**argv) {
    int i;
    // Prints arguments
    //printf("Arguments:\n");
    //for (i = 0; i < argc; i++) {
    //    printf("%i: %s\n", i, argv[i]);
    //}

    const size_t cuSize =
            sizeof (struct data [10]);
    struct data *pData;

    int nFD = open("mapped.bin", O_RDWR | O_CREAT | O_TRUNC, S_IRUSR | S_IWUSR);
    if (nFD == -1) {
        perror("open");
        return EXIT_FAILURE;
    }
    for (i = 0; i < cuSize; ++i)
        write(nFD, &i, sizeof (char));

    pData = (struct data *) mmap(
            NULL,
            cuSize,
            PROT_READ | PROT_WRITE,
            MAP_SHARED,
            nFD,
            0);
    if (pData == MAP_FAILED) {
        perror("mmap");
        close(nFD);
        return EXIT_FAILURE;
    }

    for (i = 0; i < 10; ++i) {
        pData[i].m_nNum = i;
        sprintf(pData[i].m_szData, "%d", i);
    }
    munmap(pData, cuSize);
    close(nFD);
    return EXIT_SUCCESS;
}
// main()
