----------------------------------------------------------------------------------
-- Company: SFEDU MMCS
-- Engineer: Mikhailuts Yuri
-- 
-- Create Date: 15.09.2018 00:48:10
-- Design Name: Sample_2
-- Module Name: SampleVHDL_2 - Behavioral
-- Project Name: LaboratorKey
-- Target Devices: 7A50T
-- Tool Versions: 
-- Description: 
-- 
-- Dependencies: 
-- 
-- Revision:
-- Revision 0.01 - File Created
-- Additional Comments:
-- 
----------------------------------------------------------------------------------


library IEEE;
use IEEE.STD_LOGIC_1164.ALL;

-- Uncomment the following library declaration if using
-- arithmetic functions with Signed or Unsigned values
--use IEEE.NUMERIC_STD.ALL;

-- Uncomment the following library declaration if instantiating
-- any Xilinx leaf cells in this code.
--library UNISIM;
--use UNISIM.VComponents.all;

entity SampleVHDL_2 is
    Port ( Clock : in STD_LOGIC;
           Reset : in STD_LOGIC;
           Btns : in STD_LOGIC_VECTOR (3 downto 0);
           Leds : out STD_LOGIC_VECTOR (7 downto 0));
end SampleVHDL_2;

architecture Behavioral of SampleVHDL_2 is
    signal LedsBuff: STD_LOGIC_VECTOR (7 downto 0);
begin
    Leds <= LedsBuff;
    LEDS_PROCESS: process(Clock) begin
        if (Clock'event and Clock = '1') then 
            if (Reset = '1') then
                LedsBuff <= x"00";    
            else
                LedsBuff(0) <= Btns(0) and Btns(1);
                LedsBuff(1) <= Btns(2) or Btns(3);
                LedsBuff(2) <= LedsBuff(0) xor LedsBuff(1);
                LedsBuff(3) <= LedsBuff(1) xor LedsBuff(2);
                LedsBuff(4) <= LedsBuff(2) xor LedsBuff(3);
                LedsBuff(5) <= LedsBuff(3) xor LedsBuff(4);
                LedsBuff(6) <= LedsBuff(4) xor LedsBuff(5);
                LedsBuff(7) <= LedsBuff(5) xor LedsBuff(6);
            end if;
        end if;
    end process;    
end Behavioral;
