library IEEE;
use IEEE.STD_LOGIC_1164.ALL;
use IEEE.STD_LOGIC_ARITH.ALL;
use IEEE.STD_LOGIC_UNSIGNED.ALL;

entity VHDL_TEST is
end VHDL_TEST;


architecture Behavioral of VHDL_TEST is
    signal Clock, Reset: STD_LOGIC;
    signal Btns: STD_LOGIC_VECTOR(3 downto 0);
    signal Leds: STD_LOGIC_VECTOR(7 downto 0);

    component SampleVHDL_2 is
        Port ( Clock : in STD_LOGIC;
               Reset : in STD_LOGIC;
               Btns : in STD_LOGIC_VECTOR (3 downto 0);
               Leds : out STD_LOGIC_VECTOR (7 downto 0)
        );
    end component;

begin
 
    -- Генерируем тактовую частоту с периодом 20. 20, потому что 20 = 2 * 10 - то время, чрез которое тактовый сигнал вернётся в то же состояние.  
    process begin
        Clock <= '0';
        loop
            wait for 10 ns;
            Clock <= not Clock;
        end loop;
    end process;
        
    -- Генерируем сигнал сброса. 
    process begin
        Reset <= '1';
        wait until rising_edge(Clock);
        Reset <= '0';
        wait;
    end process;
    
   
    -- Собственно генерируем данные для теста
    process 
    variable i, j: integer;
    begin
        Btns <= x"0";        
        for i in 0 to 3 loop
            for j in 0 to 7 loop
                wait until rising_edge(Clock);
            end loop;
            Btns <= conv_std_logic_vector(unsigned(Btns) + 1, 4); 
        end loop;      
        wait;  
    end process;
    
    SampleVHDL_2_Item: SampleVHDL_2
    port map  (
        Clock => Clock,
        Reset => Reset,
        Btns  => Btns,
        Leds  => Leds  
    );        


end Behavioral;
