module VerilogTest();

    reg Clock, Reset;
    reg [3:0] Btns;
    wire [7:0] Leds;

    // Генерируем тактовую частоту с периодом 20. 20, потому что 20 = 2 * 10 - то время, чрез которое тактовый сигнал вернётся в то же состояние.  
    initial begin
        Clock <= 0;
        forever begin
            #10;
            Clock <= !Clock;
        end
    end

    // Генерируем сигнал сброса. 
    initial begin
        Reset <= 1;
        @(posedge Clock)
        Reset <= 0;
    end
    
    int i, j;
    
    // Собственно генерируем данные для теста
    initial begin
        Btns <= 0;
        for (i = 0; i < 4; i += 1) begin
            for (j = 0; j < 8; j += 1) @(posedge Clock);
            Btns += 1; 
        end    
    end

    SampleVerilog_2 SampleVerilog_2_Item (
        .Clock ( Clock ),
        .Reset ( Reset ),
        .Btns  ( Btns  ),
        .Leds  ( Leds  )
    );        

endmodule
