`timescale 1ns / 1ps
//////////////////////////////////////////////////////////////////////////////////
// Company: 
// Engineer: 
// 
// Create Date: 27.10.2018 05:05:55
// Design Name: 
// Module Name: test
// Project Name: 
// Target Devices: 
// Tool Versions: 
// Description: 
// 
// Dependencies: 
// 
// Revision:
// Revision 0.01 - File Created
// Additional Comments:
// 
//////////////////////////////////////////////////////////////////////////////////


module test();

    reg       Clock;
    reg       Reset;
    wire      TxD;
         
    reg [7:0] TX_WData;
    reg TX_WValid;
    wire TX_WReady;    
    
    reg [15:0] DataCounter;
    
    initial begin
        Reset <= 1;
        Clock <= 1;
        #5ns
        Reset <= 0;
        forever begin
            #2.5ns;
            Clock <= !Clock;
        end
    end
    
    
    always@* begin
        case (DataCounter)
            0: TX_WData <= 72;  // H
            1: TX_WData <= 101; // e
            2: TX_WData <= 108; // l
            3: TX_WData <= 108; // l
            4: TX_WData <= 111; // o
            5: TX_WData <= 44; // , 
            6: TX_WData <= 32; //  
            7: TX_WData <= 87; // W
            8: TX_WData <= 111; // o
            9: TX_WData <= 114; // r
            10: TX_WData <= 108; // l
            11: TX_WData <= 100; // d
            12: TX_WData <= 33; // !
            13: TX_WData <= 33; // !
            14: TX_WData <= 33; // !
            15: TX_WData <= 13; // \r
            16: TX_WData <= 10; // \n
            default: TX_WData <= 0;
        endcase 
    end
    
    always@(posedge Clock) begin
        if (Reset) begin
            TX_WValid <= 0;
            DataCounter <= 0;    
        end else begin
            TX_WValid <= 1;
            if (TX_WReady) begin
                if (DataCounter == 16) DataCounter <= 0;
                else DataCounter <= DataCounter + 1;
            end    
        end
    end

    
    UART_TX#(
        .CLOCK_FREQUENCY ( 200000000 ),
        .BAUD_RATE ( 115200 )
    ) UART_TX_ITEM (
    //System
        .Clock  ( Clock ),
        .Reset  ( Reset ),
    //UART    
        .TxD    ( TxD ),
        .CTS    ( 1 ),
    //User    
        .WData  ( TX_WData ),
        .WValid ( TX_WValid ),
        .WReady ( TX_WReady )
    );    

    wire [7:0] RX_RData;
    wire RX_RValid, RX_RInterrupt;

    UART_RX#(
        .CLOCK_FREQUENCY ( 200000000 ),
        .BAUD_RATE ( 115200 )
    ) UART_RX_ITEM (
    //System
        .Clock  ( Clock ),
        .Reset  ( Reset ),
    //UART    
        .RxD    ( TxD ),
    //User    
        .RData  ( RX_RData ),
        .RValid ( RX_RValid ),
        .RReady ( 1 ),
        .RInterrupt ( RX_RInterrupt )
    );  

endmodule
