`timescale 1ns / 1ps
//////////////////////////////////////////////////////////////////////////////////
// Company: 
// Engineer: 
// 
// Create Date: 19.10.2018 13:59:05
// Design Name: 
// Module Name: UART
// Project Name: 
// Target Devices: 
// Tool Versions: 
// Description: 
// 
// Dependencies: 
// 
// Revision:
// Revision 0.01 - File Created
// Additional Comments:
// 
//////////////////////////////////////////////////////////////////////////////////
`include "UART.svh"
  

module UART_RX#(
    integer CLOCK_FREQUENCY = 200000000,
    integer BAUD_RATE = 115200
)(
//System
    input           Clock,
    input           Reset,
//UART    
    input           RxD,
    output reg      RTS,
//User    
    output reg[7:0] RData,
    output reg      RValid,
    output reg      RInterrupt,
    input           RReady
);    
    // Количество тактов в одном боде. 
    localparam unsigned BAUD_LENGTH = CLOCK_FREQUENCY / BAUD_RATE;
    localparam unsigned HALF_BAUD_LENGTH = CLOCK_FREQUENCY / (2 * BAUD_RATE);
    localparam unsigned PACKEGE_LENGTH = 8;    
    
    wire w_BaudTick, w_HalfBaudTick;  
    UART_STATES r_State;
    reg [3:0]   r_BitCounter;    
    reg [7:0]   r_RData_Buffer;
    logic       w_BaudCouterEnable;
    reg         r_ReceivedToSave, r_ReceivedValid;

    // Используем экземпляр счётчика для подсчёта тактов в одном боде.
    Counter#(
        .MAX_VALUE(BAUD_LENGTH)       
    ) BaudCouter (
        .Clock      (Clock),
        .Reset      (Reset),  
        .Enable     (w_BaudCouterEnable), 
        .Pause      (0), 
        .Overflow   (w_BaudTick),
        .HalfPassed (w_HalfBaudTick)
    );               
            
    always@(posedge Clock) begin
        if (Reset) begin
            RTS <= 0;
        end else begin
            RTS <= RReady;
        end
    end         
               
    // Функция выхода, выдающая принятые данные на выход.
    always@(posedge Clock) begin
        if (Reset) begin
            RData   <= 0;
            RValid  <= 0;    
            r_ReceivedValid <= 0;
            r_ReceivedToSave <= 0;
            RInterrupt <= 0;
        end else begin
            case (r_State)
                ST_SLEEP: begin
                    if (r_ReceivedToSave) begin
                        if (RReady) begin
                            RData               <= r_RData_Buffer;
                            RValid              <= r_ReceivedValid;
                            r_ReceivedToSave    <= 0;
                            r_ReceivedValid     <= 0;
                        end
                    end    
                end
                ST_STOP: begin
                    if (w_BaudTick) begin
                        if (RReady) begin
                            RData       <= r_RData_Buffer;
                            RValid      <= RxD;
                        end else begin
                            r_ReceivedToSave <= 1;   
                            r_ReceivedValid <= RxD; 
                        end 
                    end          
                end
            endcase
            RInterrupt <= (r_State == ST_STOP) && w_BaudTick;
        end
    end      
      
    // Процесс, который включает/выключает счётчик тактов. 
    // Формально это функция выхода автомата UART_RX и выходной символ, генерируемый ею, является, в свою рчередь, входным символом для автомата Counter.
    always@(posedge Clock) begin
        if (Reset) begin
            w_BaudCouterEnable <= 0;
        end else begin
            case (r_State)
                ST_SLEEP: if ((RxD == 0) && RReady) w_BaudCouterEnable <= 1;
                ST_STOP:  if (w_BaudTick) w_BaudCouterEnable <= 0;
            endcase
        end
    end
               
     // Функция состояния основного автомата UART
     always@(posedge Clock) begin
         if (Reset) begin
             r_State <= ST_SLEEP;
         end else begin
             case (r_State)
                 ST_SLEEP: if (w_HalfBaudTick)  r_State <= ST_START;   
                 ST_START: if (w_BaudTick)      r_State <= ST_WORK;     
                 ST_WORK:  if (w_BaudTick && (r_BitCounter == PACKEGE_LENGTH-1)) r_State <= ST_STOP;
                 ST_STOP:  if (w_BaudTick)      r_State <= ST_SLEEP;
                 default:  r_State <= ST_SLEEP;
             endcase
         end
     end
    
     // Функция состояния счётчика битов
     always@(posedge Clock) begin
         if (Reset) begin
             r_BitCounter <= 0;
         end else begin
             case (r_State)
                 ST_SLEEP: r_BitCounter <= 0;      
                 ST_START: r_BitCounter <= 0; 
                 ST_WORK:  if (w_BaudTick) r_BitCounter <= r_BitCounter + 1; 
                 ST_STOP:  r_BitCounter <= 0;
                 default:  r_BitCounter <= 0;
             endcase         
         end
     end    
    
     // Функция сохраняющая данные с линии RxD в буффер. (Формально это функция состояния)
     always@(posedge Clock) begin
         if (Reset) begin
             r_RData_Buffer <= 0;
         end else begin
             case (r_State)
                 ST_SLEEP: r_RData_Buffer <= 0;   
                 ST_START: r_RData_Buffer <= 0;     
                 ST_WORK:  if (w_HalfBaudTick) r_RData_Buffer[r_BitCounter] <= RxD;
             endcase
         end
     end
         
endmodule
