`timescale 1ns / 1ps
//////////////////////////////////////////////////////////////////////////////////
// Company: 
// Engineer: 
// 
// Create Date: 19.10.2018 13:59:05
// Design Name: 
// Module Name: UART
// Project Name: 
// Target Devices: 
// Tool Versions: 
// Description: 
// 
// Dependencies: 
// 
// Revision:
// Revision 0.01 - File Created
// Additional Comments:
// 
//////////////////////////////////////////////////////////////////////////////////
`include "UART.svh"


module UART_TX#(
    integer CLOCK_FREQUENCY = 200000000,
    integer BAUD_RATE = 115200
)(
//System
    input           Clock,
    input           Reset,
//UART    
    output logic    TxD,
    input           CTS,
//User    
    input [7:0]     WData,
    input           WValid,
    output          WReady
);    
    // Количество тактов в одном боде. 
    localparam unsigned BAUD_LENGTH = CLOCK_FREQUENCY / BAUD_RATE;
    localparam unsigned PACKEGE_LENGTH = 8;    
    
    wire w_BaudTick;  
    
    UART_STATES r_State;
    
    reg [3:0] r_BitCounter;
    
    reg [7:0] r_WData_Buffer;
    
    wire w_BaudCouterEnable = (r_State != ST_SLEEP);

    // Используем экземпляр счётчика для подсчёта тактов в одном боде.
    Counter#(
        .MAX_VALUE(BAUD_LENGTH)       
    ) BaudCouter (
        .Clock      (Clock),
        .Reset      (Reset),  
        .Enable     (w_BaudCouterEnable), 
        .Pause      (0), 
        .Overflow   (w_BaudTick)
    );
    
    // Функция выхода TxD
    always@* begin
        case (r_State)
            ST_SLEEP: TxD <= 1;      
            ST_START: TxD <= 0;
            ST_WORK:  TxD <= r_WData_Buffer[r_BitCounter];
            ST_STOP:  TxD <= 1;
            default:  TxD <= 1; 
        endcase 
    end     
    
    // Сообщаем клиенту о готовности к передаче данных. (Формально это тоже функция выхода)
    assign WReady = ((r_State == ST_SLEEP) && CTS);
    
   
    // Функция состояния основного автомата
    always@(posedge Clock) begin
        if (Reset) begin
            r_State <= ST_SLEEP;
        end else begin
            case (r_State)
                ST_SLEEP: if (WValid && CTS) r_State <= ST_START;
                ST_START: if (w_BaudTick) r_State <= ST_WORK;   
                ST_WORK:  if (w_BaudTick && (r_BitCounter == PACKEGE_LENGTH-1)) r_State <= ST_STOP;
                ST_STOP:  if (w_BaudTick) r_State <= ST_SLEEP;
                default:  r_State <= ST_SLEEP;
            endcase
        end
    end
    
    // Функция состояния счётчика битов
    always@(posedge Clock) begin
        if (Reset) begin
            r_BitCounter <= 0;
        end else begin
            case (r_State)
                ST_SLEEP: r_BitCounter <= 0;      
                ST_START: r_BitCounter <= 0; 
                ST_WORK:  if (w_BaudTick) r_BitCounter <= r_BitCounter + 1; 
                ST_STOP:  r_BitCounter <= 0;
                default:  r_BitCounter <= 0;
            endcase         
        end
    end
    
    // Процесс, сохраняющий данные с порта во внутренний буфер. (Формально это тоже функция состояния)
    always@(posedge Clock) begin
        if (Reset) begin
            r_WData_Buffer <= 0;
        end else begin
            if (WValid && CTS && (r_State == ST_SLEEP)) r_WData_Buffer <= WData;
        end
    end
    
    
    
endmodule





