`timescale 1ns / 1ps
//////////////////////////////////////////////////////////////////////////////////
// Company: 
// Engineer: 
// 
// Create Date: 19.10.2018 14:25:17
// Design Name: 
// Module Name: Counter
// Project Name: 
// Target Devices: 
// Tool Versions: 
// Description: 
// 
// Dependencies: 
// 
// Revision:
// Revision 0.01 - File Created
// Additional Comments:
// 
//////////////////////////////////////////////////////////////////////////////////


module Counter#(
    integer MAX_VALUE = 100       
)(
    input       Clock,
    input       Reset,  
    input       Enable,  
    input       Pause,
    output reg  Overflow,
    output reg  HalfPassed
);
    localparam unsigned BIT_WIDTH = ($clog2(MAX_VALUE)/$clog2(2)) + 1;
    
    reg [BIT_WIDTH-1:0] m_Counter;
    
    // Собственно, процесс счётчика.
    always@(posedge Clock) begin
       if (Reset) begin
           m_Counter <= 0;    
           Overflow  <= 0;
           HalfPassed <= 0;
       end else begin
           if (Enable) begin
           // Если включён, то работаем  
               if (!Pause) begin
                   // Считаем только если не поставили на паузу                     
                   if (m_Counter == MAX_VALUE) begin
                       m_Counter <= 0;
                       Overflow <= 1;
                       HalfPassed <= 0;
                   end else if (m_Counter == MAX_VALUE/2) begin 
                       m_Counter <= m_Counter + 1;
                       Overflow <= 0;
                       HalfPassed <= 1;
                   end else begin
                       m_Counter <= m_Counter + 1;
                       Overflow <= 0;
                       HalfPassed <= 0;
                   end
                   // Если стоим на паузе, то не ничего сбрасываем, а просто курим в ожидании.
               end
           end else begin
               // Иначе всё сбрасываем. 
               m_Counter  <= 0;    
               Overflow   <= 0;
               HalfPassed <= 0;          
               // По сути это альтернатива сигналу Reset. 
               // Но он нужен, что бы не вмешиваться в общий сигнал сброса. 
           end
       end        
    end;       
        
    

endmodule
