`timescale 1ns / 1ps
//////////////////////////////////////////////////////////////////////////////////
// Company: 
// Engineer: 
// 
// Create Date: 19.10.2018 13:59:05
// Design Name: 
// Module Name: UART
// Project Name: 
// Target Devices: 
// Tool Versions: 
// Description: 
// 
// Dependencies: 
// 
// Revision:
// Revision 0.01 - File Created
// Additional Comments:
// 
//////////////////////////////////////////////////////////////////////////////////

module UART#(
    integer CLOCK_FREQUENCY = 200000000,
    integer BAUD_RATE = 9600
)(
//System
    input           Clock,
    input           Reset,
//UART    
    input           RxD,
    output          TxD,
    input           CTS,
    output          RTS,
//User    
    output    [7:0] RData,
    output          RValid,
    input           RReady,
    output          RInterrupt,    
    input [7:0]     WData,
    input           WValid,
    output          WReady
);    
    
    UART_TX#(
        .CLOCK_FREQUENCY ( CLOCK_FREQUENCY ),
        .BAUD_RATE ( BAUD_RATE )
    ) UART_TX_ITEM (
    //System
        .Clock  ( Clock ),
        .Reset  ( Reset ),
    //UART    
        .TxD    ( TxD ),
        .CTS    ( CTS ),
    //User    
        .WData  ( WData ),
        .WValid ( WValid ),
        .WReady ( WReady )
    );    
    
    UART_RX#(
        .CLOCK_FREQUENCY ( CLOCK_FREQUENCY ),
        .BAUD_RATE ( BAUD_RATE )
    ) UART_RX_ITEM (
    //System
        .Clock  ( Clock ),
        .Reset  ( Reset ),
    //UART    
        .RxD    ( RxD ),
        .RTS    ( RTS ),
    //User    
        .RData  ( RData ),
        .RValid ( RValid ),
        .RReady ( RReady ),
        .RInterrupt ( RInterrupt )
    );    
    
    
endmodule
