`timescale 1ns / 1ps
//////////////////////////////////////////////////////////////////////////////////
// Company: 
// Engineer: 
// 
// Create Date: 19.10.2018 11:55:57
// Design Name: 
// Module Name: main
// Project Name: 
// Target Devices: 
// Tool Versions: 
// Description: 
// 
// Dependencies: 
// 
// Revision:
// Revision 0.01 - File Created
// Additional Comments:
// 
//////////////////////////////////////////////////////////////////////////////////


module main(
    input       Clock,
    input       Reset,
    output      TxD,
    input       RxD,
    input [7:0] Switch,
    output [7:0] LEDs
);       
   
    logic [7:0] RData;
    logic RValid, RInterrupt;
    logic RReady;
    logic [7:0] WData;
    logic WValid;
    logic WReady;    
       
  
    assign LEDs[0] = !RxD;
    
  
    
    always@(posedge Clock) begin
        if (Reset) begin
            WData  <= 0;
            WValid <= 0;
            RReady <= 0;
        end else begin
            RReady <= 1;
            if (RInterrupt) begin
                WData  <= RData;
                WValid <= 1;                
            end else if (WValid) begin
                WData  <= 0;
                WValid <= 0;            
            end
        end
    end
     
        
    
    UART#(
        .CLOCK_FREQUENCY ( 200000000 ),
        .BAUD_RATE ( 115200 )
    ) UART_Item (
    //System
        .Clock      ( Clock ),
        .Reset      ( Reset ),
    //UART    
        .RxD        ( RxD ),
        .TxD        ( TxD ),
        .CTS        ( 1 ),
    //User    
        .RData      ( RData ),
        .RValid     ( RValid ), 
        .RReady     ( 1 ),
        .RInterrupt ( RInterrupt ),
        .WData      ( WData ),
        .WValid     ( WValid ),
        .WReady     ( WReady )
    );   
    
    
endmodule
