`timescale 1ns / 1ps
//////////////////////////////////////////////////////////////////////////////////
// Company: 
// Engineer: 
// 
// Create Date: 23.12.2018 17:57:37
// Design Name: 
// Module Name: ControlUnit
// Project Name: 
// Target Devices: 
// Tool Versions: 
// Description: 
// 
// Dependencies: 
// 
// Revision:
// Revision 0.01 - File Created
// Additional Comments:
// 
//////////////////////////////////////////////////////////////////////////////////

`include "ControlUnit.svh"


module ControlUnit(
    input Clock,
    input Reset,
	// RAM
    output logic[7:0] 	Addr,
    input 		[7:0] 	DataIn,
    input 				VldIn,
    // GPR
    input 		[7:0] 	RegIn,
    output logic[7:0] 	RegOut,
    output logic[7:0] 	RegIdx,
    output logic		RegWr,
    // ALU
    output logic[7:0]	ALUL,
    output logic		ALULWr,
    output logic[7:0]	ALUR,
    output logic		ALURWr,
    input  logic[7:0] 	ALURes
);
    
	CU_StateEnum rState;
	CPU_OP_CODES rOpCode;
	reg[7:0] rIP;
	reg[7:0] rLeftArg;
	reg[7:0] rRightArg;
	
	always@(posedge Clock) begin
		if (Reset) begin
			rState <= CU_SET_OPCODE_ADDR;
			rIP <= 0;
		end else begin
			case (rState) 
				CU_SET_OPCODE_ADDR: begin
					rIP+=VldIn;
					if (VldIn) rState <= CU_READ_OPCODE; 
				end 
				CU_READ_OPCODE: begin
					rOpCode <= CPU_OP_CODES'(DataIn);
					rState <= CU_SET_LEFTARG_ADDR; 	
				end
				CU_SET_LEFTARG_ADDR: begin
					rIP+=VldIn;
					if (VldIn) rState <= CU_READ_LEFTARG; 
				end
				CU_READ_LEFTARG: begin
					rLeftArg <= DataIn;
					rState <= (rOpCode == CPU_OC_FARJAMP)?CU_SET_IP_LEFTARG:CU_SET_RIGHTARG_ADDR; 
				end 
				CU_SET_IP_LEFTARG: begin 
					rIP <= rLeftArg;
					rState <= CU_SET_OPCODE_ADDR; 
				end 
				CU_SET_RIGHTARG_ADDR: begin
					rIP+=VldIn;					
					if (VldIn) rState <= CU_READ_RIGHTARG;
				end 
				CU_READ_RIGHTARG: begin
					rRightArg <= DataIn;
					case (rOpCode) 
						CPU_OC_MOVRC:	rState <= CU_ST_MOVERC;  
						CPU_OC_ADDRR:	rState <= CU_ST_ADDRR_0; 
						default:		rState <= CU_SET_OPCODE_ADDR;					
					endcase
				end 
				CU_ST_MOVERC: begin
					rState <= CU_SET_OPCODE_ADDR;
				end 
				CU_ST_ADDRR_0: begin
					rState <= CU_ST_ADDRR_1;
				end 
				CU_ST_ADDRR_1: begin
					rState <= CU_ST_ADDRR_2;
				end 
				CU_ST_ADDRR_2: begin
					rState <= CU_ST_ADDRR_3;
				end 
				CU_ST_ADDRR_3: begin
					rState <= CU_SET_OPCODE_ADDR; 		
				end 
			endcase
		end
	end    
	

	always@* begin
		Addr 	= 0;
		RegWr 	= 0;
		RegIdx 	= 0;
		RegOut 	= 0;
		ALUL    = 0;
		ALULWr  = 0; 
		ALUR    = 0;
		ALURWr  = 0; 
		case (rState) 
			CU_SET_OPCODE_ADDR: begin
				Addr   = rIP;
			end 
			CU_SET_LEFTARG_ADDR: begin
				Addr   = rIP;
			end
			CU_SET_RIGHTARG_ADDR: begin
				Addr   = rIP;
			end 
			CU_ST_MOVERC: begin
				RegIdx = rLeftArg;
				RegOut = rRightArg;
				RegWr  = 1;
			end 
			CU_ST_ADDRR_0: begin
				RegIdx = rLeftArg;
			end 
			CU_ST_ADDRR_1: begin
				RegIdx = rRightArg;
				ALUL   = RegIn;
				ALULWr = 1;
			end 
			CU_ST_ADDRR_2: begin
				ALUR   = RegIn;
				ALURWr = 1;
			end 
			CU_ST_ADDRR_3: begin
				RegOut = ALURes;
				RegIdx = rLeftArg;
				RegWr  = 1;
			end 
		endcase		
	end
    
endmodule



