`include "ControlUnit.svh"

module CU_test();
	
	const byte CODE_RAM [0:10] = {
		byte'(CPU_OC_MOVRC),	// 0
		1,
		12,
		byte'(CPU_OC_MOVRC),	// 3
		2,
		34,
		byte'(CPU_OC_ADDRR),	// 6
		1,
		2,
		byte'(CPU_OC_FARJAMP),	// 9
		6
	};
	

	const time CLOCK_HALF_PERIOD = 1ns;
	
	logic Clock, Reset;
	// RAM
	logic[7:0] 	Addr;
	logic[7:0] 	DataIn;
	logic		VldIn = 1;
	// GPR
	logic[7:0] 	RegIn;
	logic[7:0] 	RegOut;
	logic[7:0] 	RegIdx;
	logic		RegWr;
	// ALU
	logic[7:0]	ALUL;
	logic		ALULWr;
	logic[7:0]	ALUR;
	logic		ALURWr;
	logic[7:0] 	ALURes;


	logic [7:0] GPR [7:0];

	logic[7:0]	ALULeft;
	logic[7:0]	ALURight;
	
	assign ALURes = ALULeft + ALURight;
	
	always@(posedge Clock) begin
		DataIn <= CODE_RAM[Addr];
		RegIn  <= GPR[RegIdx]; 
		if (RegWr) 
			GPR[RegIdx]	<= RegOut;
		if (ALULWr) 
			ALULeft 	<= ALUL;
		if (ALURWr) 
			ALURight 	<= ALUR;		
	end; 
	
	initial begin
		Clock <= 0;
		forever begin
			#CLOCK_HALF_PERIOD;
			Clock <= !Clock;
		end;
	end;
		
	initial begin
		Reset <= 1;
		wait (Clock);
		@(posedge Clock);
		Reset <= 0;
	end;
	
	ControlUnit CU (
		.Clock		(Clock	),
		.Reset		(Reset	),
		// RAM
		.Addr		(Addr  	),
		.DataIn		(DataIn	),
		.VldIn		(VldIn  ),
		// GPR
		.RegIn		(RegIn 	),
		.RegOut		(RegOut	),
		.RegIdx		(RegIdx	),
		.RegWr		(RegWr	),
		// ALU
		.ALUL		(ALUL  	),
		.ALULWr		(ALULWr	),
		.ALUR		(ALUR  	),
		.ALURWr		(ALURWr	),
		.ALURes		(ALURes	)
	);
	

endmodule