 { FlexPDE 2.14a 3D}
 { St3LS_1.pde -   
                                 }
 {      1/8   }

  Title '     '
  
 coordinates 
     cartesian3

  select
    errlim = 1e-4	{     }
 
  variables
    U                   { U, V  W}
    V
    W

  definitions
    a=5	{  }
    b=2	{  }
    h=0.1 { }
    R=0.25	{ }
    p=1e3  {   (/^2)}
    nu = 0.3	{   }
    E  = 2e6 	{    (/^2)}

    mu  = E/2/(1+nu)	{ }
    lambda =  2*mu*nu/(1-2*nu)   {. }
    Sxx = dx(U)		{  Sxx, Syy, Szz}
    Syy = dy(V) 
    Szz = dz(W)
    Sxy = (dy(U)+dx(V))/2	{  Sxy, Sxz, Syz}
    Sxz = (dz(U)+dx(W))/2
    Syz = (dz(V)+dy(W))/2
    Txx= lambda*(Sxx+Syy+Szz)+2*mu*Sxx        { Txx, Tyy, Tzz}
    Tyy= lambda*(Sxx+Syy+Szz)+2*mu*Syy       
    Tzz= lambda*(Sxx+Syy+Szz)+2*mu*Szz 
    Txy=2*mu*Sxy			 { Txy, Txz, Tyz}
    Txz=2*mu*Sxz	
    Tyz=2*mu*Syz	
    mcoeff=0.2    {    }
    Scal=mcoeff*globalmax(magnitude(x,y,z))/globalmax(magnitude(U,V,W))

    RR=sqrt(x*x+y*y)     theta=arcsin(y/RR)  {RR,  theta -   }
    {     }
    Trr=Txx*(cos(theta))**2+Tyy*(sin(theta))**2+Txy*sin(2*theta)
    Tthetatheta=Txx*(sin(theta))**2+Tyy*(cos(theta))**2-Txy*sin(2*theta)

initial values
    U = 1.e-5
    V = 1.e-5
    W = 0

  equations      {   
                                  }

     dx(Txx)+dy(Txy)+dz(Txz) = 0
     dx(Txy)+dy(Tyy)+dz(Tyz) = 0
     dx(Txz)+dy(Tyz)+dz(Tzz) = 0

 extrusion 
   surface  z=0
   surface  z=h/2
   
  boundaries       {    }

   surface 1 value(W)=0   {       Z=0  W=0}
   surface 2 load(W)=0 

    region 1
      start (R,0)
      load(U)=0       {    Y=0}
      value(V)=0
      line to (a,0)   
 
      load(U)=p      { }
      load(V) = 0
      line to (a,b)    
      
      load(U)=0        {    }
      load(V)=0 
      line to (0,b)    

      value(U)=0     {     X=0}
      load(V) = 0
      line to (0,R) 

      load(U)=0        {    }
      load(V)=0 
      arc(center=0,0)  to finish
      

  monitors
      grid(x+Scal*U,y+Scal*V) on surface z=0 as "XY Shape"
    {      z=0
                                          }

  plots                 {   }
     grid(x+Scal*U,y+Scal*V) on surface z=0 as " "     
     contour(Txx) on surface z=0 painted as " Txx"
     contour(Tyy) on surface z=0 painted as " Tyy"
     contour(Tthetatheta) on surface z=0 painted as " Tthetatheta"  
     contour(Tthetatheta)  on surface z=0 as " Tthetatheta, z=0"  
     contour(Tthetatheta)  on surface z=h/2 as " Tthetatheta, z=h/2"  
     elevation(Tthetatheta)on surface z=0  from (0,R) to (0,b) as "Tthetatheta   x=0"
     contour(Trr) on surface z=0 as " Trr"

  end 


 
