 { FlexPDE 2.14a}
 { St2LS_1.pde -      }
 {        }

  Title '     '
  
  select
    errlim = 1e-5	{     }
 
  variables
    U                   { U  V -  }
    V

  definitions
    a=5	{  }
    b=2	{  }
    R=0.25	{ }
    p=1e3  {   (/^2)}
    nu = 0.3	{   }
    E  = 2e6 	{    (/^2)}

    mu  = E/2/(1+nu)	{ }
    lambda =  2*mu*nu/(1-2*nu)   {. }
	{lambdaz - .      }
    lambdaz = 2*mu*lambda/(lambda+2*mu) 
    Sxx = dx(U)		{  Sxx}
    Syy = dy(V)		{  Syy}
    Sxy = (dy(U)+dx(V))/2	{  Sxy}
    Txx= lambdaz*(Sxx+Syy)+2*mu*Sxx        { Txx}
    Tyy= lambdaz*(Sxx+Syy)+2*mu*Syy       { T}
    Txy=2*mu*Sxy			 { Txy}
    mcoeff=0.2    {    }
    Scal=mcoeff*globalmax(magnitude(x,y))/globalmax(magnitude(u,v))

  {  RR=sqrt(x*x+y*y)     theta=arcsin(y/RR)  {RR,  theta -   }
    {     }
    Trr=Txx*(cos(theta))**2+Tyy*(sin(theta))**2+Txy*sin(2*theta)
    Tthetatheta=Txx*(sin(theta))**2+Tyy*(cos(theta))**2-Txy*sin(2*theta)}

  equations      {   
                                  }
     dx(Txx) +dy(Txy)  = 0
     dx(Txy)+dy(Tyy)  = 0
 
   
  boundaries       {    }
    region 1

start(0,0)
load(U)=0
load(V)=0
line to (0,a)

load(U)=0
load(V)=p
line to (a,a)

load(U)=0
load(V)=0
line to (a,0)

value(U)=0
value(V)=0
line to (4,0)
      
load(U)=0
load(V)=0
line to (4,4)

load(U)=0
load(V)=0
line to (1,4)

load(U)=0
load(V)=0
line to (1,0)

value(U)=0
value(V)=0
line to (0,0)

  monitors
      grid(x+Scal*U,y+Scal*V)     {   
                                          }

  plots                 {   }
     grid(x+Scal*U,y+Scal*V) as " "     
     contour(Txx) painted as " Txx"
     contour(Tyy) painted as " Tyy"
 {    contour(Tthetatheta) painted as " Tthetatheta"  
     contour(Tthetatheta)  as " Tthetatheta"  
     elevation(Tthetatheta) from (0,R) to (0,b) as "Tthetatheta   x=0"}

{     contour(Trr) as " Trr"
}
  end 


 
