#ifndef _DUMP_H_
#define _DUMP_H_

typedef unsigned char        BYTE;
typedef unsigned short       WORD;
typedef unsigned int         DWORD;

typedef struct _PCAPFILEHDR {
	DWORD		magic;
	WORD		version_major;
	WORD		version_minor;
	DWORD		thiszone;
	DWORD		sigfigs;
	DWORD		snap_len;
	DWORD		linktype;
} PCAPFILEHDR;

typedef struct _TVAL {			
	DWORD	sec;
	DWORD	usec;
} TVAL;

typedef struct _PCAPPKTHDR {
	TVAL ts;								//   winsock.h
	DWORD	caplen;
	DWORD	len;
} PCAPPKTHDR;

typedef struct _IPHDR {
	BYTE	ihl:4, version:4;
	BYTE	tos;
	WORD	tot_len;
	WORD	id;
	WORD	frag_off;
	BYTE	ttl;
	BYTE	protocol;
	WORD	check;
	DWORD	saddr;
	DWORD	daddr;
} IPHDR, *PIPHDR;

typedef struct _ICMPHDR {
	BYTE	type;
	BYTE	code;
	WORD	checksum;
	union {
		struct {
			WORD	id;
			WORD	sequence;
		}	echo;
		DWORD	gateway;
		struct {
			WORD	reserved;
			WORD	mtu;
		}	frag;
	} un;
} ICMPHDR, *PICMPHDR;

typedef struct _TCPHDR {
	WORD	source;
	WORD	dest;
	DWORD	seq;
	DWORD	ack_seq;
	BYTE	res;
	BYTE	flags;
	WORD	window;
	WORD	check;
	WORD	urg_ptr;
} TCPHDR, *PTCPHDR;

typedef struct _EVENT {
	IPHDR ip;
	union {
		ICMPHDR		icmp;
		TCPHDR		tcp;
//		UDPHDR		udp;
	};
	BYTE	rezerved[1024];
} EVENT, *PEVENT;

#endif	// _DUMP_H_
