#include <string>
#include <iostream>
#include <fstream>

#include <vector>

using namespace std;

int SplitLine(const string& line, const string& delimeter, std::vector<string>& items)
{
	items.empty();
	
	// Split the line by delimeters:
	string tmp;
	int start = 0;
	int end = line.find(delimeter);
	while (end != -1)
	{
		tmp = line.substr(start, end - start);
		items.push_back(tmp);
		
		start = end + delimeter.size();
		end = line.find(delimeter, start);
	}
	// Don't forget to add the last item
	tmp = line.substr(start);
	items.push_back(tmp);

	// Return the quantity of read items.
	return items.size();
}

int main(int argc, const char* argv[])
{
	if (argc == 3)
	{
		try
		{
			const char* InputFile = argv[1];
			const char* OutputFile = argv[2];

			// Reading input data
			ifstream fin(InputFile, ios::in);
			if (!fin.is_open())
			{
				throw "Input file not found";
				exit(1);
			}
			string line;
			getline(fin, line);
			// TODO: parse the 1st line
			vector<string> items;
			SplitLine(line, " ", items);
			while (getline(fin, line))
			{
				// TODO: iteratively parse lines of the file
				SplitLine(line, " ", items);
			}
			fin.close();

			// TODO: process data, solve the problem and yield the result.

			// Writing output
			ofstream fout(OutputFile);
			if (!fout.is_open()) throw "Cannot open output file";
			// TODO: output your result
			fout << "demo" << endl;
			fout.close();

		}
		catch (const std::exception& e) {
			cout << "Exeption: " << e.what() << endl;
		}
		return 0;
	}
	cout << "Invalid count of arguments" << endl;
	return 0;
}
