
import java.util.Collections;

import javafx.application.Application;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.control.TextArea;
import javafx.scene.control.ToolBar;
import javafx.scene.layout.HBox;
import javafx.scene.layout.VBox;
import javafx.scene.web.HTMLEditor;
import javafx.stage.Stage;

public class HTMLMain extends Application {

   public static void main(String[] args) {
      Application.launch(args);
   }

   public void start(Stage stage) throws Exception {
      VBox root = new VBox(15.0);
      root.setAlignment(Pos.CENTER);
      root.setPadding(new Insets(20.0));
      Button button = new Button("Класс HTMLEditor");
      Button button2 = new Button("Класс HTMLEditor + TextArea");
      
      button.setOnAction(event -> {
         newWindow();
      });
      button2.setOnAction(event -> {
         newWindow2();
      });
      
      root.getChildren().addAll(button, button2);
      Scene scene = new Scene(root, 400.0, 200.0);
      stage.setTitle("Класс HTMLEditor");
      stage.setScene(scene);
      stage.show();
   }

   public void newWindow() {
      Stage window = new Stage();

      VBox pane = new VBox(15.0);
      pane.setPadding(new Insets(20.0));

      HTMLEditor editor = new HTMLEditor();
      editor.setHtmlText(
            "<html><head><title>Название</title></head><body>"
            + "<h1>Заголовок</h1>"
            + "<p>Абзац 1 <b>выделенный текст</b></p>"
            + "<p>Абзац 2 <u>подчеркнутый текст</u></p>"
            + "</body></html>");
      pane.getChildren().add(editor);

      Button button = new Button("Получить HTML-текст");
      button.setOnAction(event -> {
         System.out.println(editor.getHtmlText());
      });
      
      Button button2 = new Button("Вывести структуру редактора");
      button2.setOnAction(event -> {
         printTreeNodes(editor, 1);
      });
      
      Button button3 = new Button("Отключить/включить панели");
      button3.setOnAction(event -> {
         Node node = editor.lookup(".top-toolbar");
         if (node instanceof ToolBar) {
            ToolBar topToolbar = (ToolBar) node;
            topToolbar.setDisable(!topToolbar.isDisable());
         }
         node = editor.lookup(".bottom-toolbar");
         if (node instanceof ToolBar) {
            ToolBar bottomToolbar = (ToolBar) node;
            bottomToolbar.setDisable(!bottomToolbar.isDisable());
         }
      });
      
      pane.getChildren().add(button);
      pane.getChildren().add(new HBox(5.0, button2, button3));
      
      Scene scene = new Scene(pane, 600, 500);
      window.setScene(scene);
      window.setTitle("Класс HTMLEditor");
      window.show();
   }
   
   public void newWindow2() {
      Stage window = new Stage();

      VBox pane = new VBox(15.0);
      pane.setPadding(new Insets(2.0));

      HTMLEditor editor = new HTMLEditor();
      //editor.setPrefHeight(350.0);
      editor.setHtmlText(
            "<html><head><title>Название</title></head><body>"
            + "<h1>Заголовок</h1>"
            + "<p>Абзац 1 <b>выделенный текст</b></p>"
            + "</body></html>");
      pane.getChildren().add(editor);

      TextArea text = new TextArea();
      text.setWrapText(true);
      text.setMinHeight(200.0);
      text.setPrefHeight(200.0);
      
      Button button = new Button("Получить HTML-текст");
      button.setOnAction(event -> {
         text.setText(editor.getHtmlText());
      });
      
      Button button2 = new Button("Отобразить HTML-текст в редакторе");
      button2.setOnAction(event -> {
         editor.setHtmlText(text.getText());
      });
      
      pane.getChildren().add(new HBox(5.0, button, button2));
      pane.getChildren().add(text);
      
      Scene scene = new Scene(pane, 600, 600);
      window.setScene(scene);
      window.setTitle("Класс HTMLEditor");
      window.show();
   }
   
   public static void printTreeNodes(Parent parent, int level) {
      String s = String.join("", 
                    Collections.nCopies((level - 1) * 3, " "));
      System.out.println(s + "+ " + parent);
      for (Node node: parent.getChildrenUnmodifiable()) {
         if (node instanceof Parent) {
            printTreeNodes((Parent)node, level + 1);
         }
         else {
            System.out.println(s + "   - " + node);
         }
      }
   }
}
