import javafx.application.Application;
import javafx.geometry.Pos;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.Pane;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Color;
import javafx.scene.shape.Rectangle;
import javafx.stage.Stage;
import javafx.stage.StageStyle;


public class Clip extends Application {

   public static void main(String[] args) {
      Application.launch(args);
   }

   public void start(Stage stage) throws Exception {
      VBox root = new VBox(15.0);
      root.setAlignment(Pos.CENTER);
      Button button = new Button("Открыть окно");
      Button button2 = new Button("Открыть окно2");
      button.setOnAction(event -> {
         newWindow();
      });
      button2.setOnAction(event -> {
         newWindow2();
      });
      root.getChildren().addAll(button, button2);

      Scene scene = new Scene(root, 400.0, 300.0);
      stage.setTitle("Маски слоя");
      stage.setScene(scene);

      stage.show();
   }

   public void newWindow() {
      Stage window = new Stage();
      Rectangle rect = new Rectangle(100.0, 100.0);
      rect.setFill(Color.RED);
      rect.setId("rectRed");
      rect.relocate(100.0, 100.0);
      Rectangle maskRect = new Rectangle(150.0, 30.0);
      maskRect.relocate(-50.0, 10.0);
      maskRect.setRotate(45.0);
      rect.setClip(maskRect);

      Rectangle rect2 = new Rectangle(100.0, 100.0);
      rect2.setFill(Color.GREEN);
      rect2.setId("rectGreen");
      rect2.relocate(300.0, 100.0);
      
      
      Pane pane = new Pane();
      Rectangle mask = new Rectangle(540.0, 340.0);
      mask.relocate(30.0, 30.0);
      mask.setArcWidth(20);
      mask.setArcHeight(20);
      pane.setClip(mask);
      
      pane.getChildren().addAll(rect, rect2);
      Point click = new Point(0, 0);
      Scene scene = new Scene(pane, 600, 400, Color.BISQUE);
      window.setScene(scene);
      window.setTitle("Маски слоя");
      rect.addEventHandler(MouseEvent.MOUSE_PRESSED, event -> {
         click.setPoint(event.getX(), event.getY());
      });
      rect.addEventHandler(MouseEvent.MOUSE_DRAGGED, event -> {
         rect.relocate(event.getSceneX() - click.getX(), 
                       event.getSceneY() - click.getY());
      });
      rect2.addEventHandler(MouseEvent.MOUSE_PRESSED, event -> {
         click.setPoint(event.getX(), event.getY());
      });
      rect2.addEventHandler(MouseEvent.MOUSE_DRAGGED, event -> {
         rect2.relocate(event.getSceneX() - click.getX(), 
                        event.getSceneY() - click.getY());
      });
      scene.addEventHandler(MouseEvent.MOUSE_PRESSED, event -> {
         if (event.getTarget() instanceof Rectangle) {
            Rectangle node = (Rectangle)event.getTarget();
            if (event.getClickCount() == 2) {
               if (event.isPrimaryButtonDown()) node.toFront();
               else if (event.isSecondaryButtonDown()) node.toBack();
            }
         }
      });
      window.setResizable(false);
      window.show();
   }
   
   public void newWindow2() {
      Stage window = new Stage(StageStyle.TRANSPARENT);
      Pane pane = new Pane();
      ImageView iv = new ImageView();
      try {
         Image img = new Image(getClass().getResourceAsStream("mask.png"));
         iv.setImage(img);
         pane.setClip(iv);
      } catch (Exception e) {
         System.out.println("Не удалось загрузить изображение");
      }
      
      Button btn = new Button("Закрыть окно");
      btn.relocate(250, 180);
      btn.setOnAction(event -> {
         window.close();
      });
      pane.getChildren().addAll(btn);

      Scene scene = new Scene(pane, 600, 400, Color.TRANSPARENT);
      window.setScene(scene);
      window.setTitle("Маски слоя");
      window.show();
   }
}

class Point {
   private double x, y;

   public Point(double x, double y) {
      this.x = x;
      this.y = y;
   }
   public double getX() {
      return x;
   }

   public void setX(double x) {
      this.x = x;
   }

   public double getY() {
      return y;
   }

   public void setY(double y) {
      this.y = y;
   }
   
   public void setPoint(double x, double y) {
      this.x = x;
      this.y = y;
   }
   
   @Override
   public String toString() {
      return "Point [x=" + x + ", y=" + y + "]";
   }
}