from tkinter import *
import math


def arrow(x0, y0, d, alpha, color):
    '''
    рисует стрелку длины d из точки (x0,y0)
    под углом alpha к оси x цветом color
    '''
    spike = 10 # размер острия 
    x1 = x0 + d*math.cos(alpha)
    y1 = y0 - d*math.sin(alpha)
    beta1 = math.pi + alpha - math.pi/10
    beta2 = math.pi + alpha + math.pi/10
    w.create_line(x0, y0, x1, y1, width=3, fill=color)
    w.create_line(x1, y1,
                  x1+spike*math.cos(beta1),
                  y1-spike*math.sin(beta1), width=2, fill=color)
    w.create_line(x1, y1,
                  x1+spike*math.cos(beta2),
                  y1-spike*math.sin(beta2), width=2, fill=color)
       
root = Tk()
w = Canvas(root, width=300, height=300)
w.pack()

arrow(150,100, 60, math.pi/4, 'red')
arrow(10,50, 100, -math.pi/4, 'blue')

root.mainloop()
