from tkinter import *
from tkinter import messagebox

def on_closing():
    if messagebox.askokcancel("Выход из приложения", "Хотите выйти из приложения?"):
        tk.destroy()

def start_new_window():
    global window_on, new_window
    if window_on: # если окно уже есть, новое не создается
        return
    new_window = Toplevel(tk)
    new_window.title("Новое окно")
    new_window.resizable(0, 0)
    new_window.wm_attributes("-topmost", 1)
    new_window.protocol("WM_DELETE_WINDOW", on_closing_new_window)
    canvas_1 = Canvas(new_window, width=400, height=200, bg="yellow", highlightthickness=0)
    canvas_1.pack()
    canvas_1.create_rectangle(50, 50, 150, 150, fill="green", outline="")
    canvas_1.create_text(10,20, anchor=SW, text="Это - новое окно!", font=("Arial", 12),fill="blue")
    window_on = True # флаг присутствия окна на экране

def on_closing_new_window():
    global window_on, new_window
    window_on = False
    new_window.destroy()

tk = Tk()
tk.protocol("WM_DELETE_WINDOW", on_closing)
tk.title("Главное окно")
tk.resizable(0, 0)
tk.wm_attributes("-topmost", 1)

canvas = Canvas(tk, width=400, height=400, bg="red", highlightthickness=0)
canvas.pack()

window_on = False
b0 = Button(tk, text="Второе окно", command=start_new_window)
b0.place(x=160, y=210)

tk.mainloop()
