import java.util.Collections;
import java.util.Set;

import javafx.application.Application;
import javafx.event.ActionEvent;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Pane;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Color;
import javafx.stage.Stage;

public class App extends Application {
   
   public static void main(String[] args) {
      Application.launch(args);
   }

   @Override
   public void start(Stage stage) throws Exception {
      BorderPane root = new BorderPane();
      Button button = new Button("Открыть окно");
      root.setCenter(button);
      button.setOnAction(event -> {
         newWindow();
      });
      Scene scene = new Scene(root, 400, 150);
      stage.setTitle("Поиск узла");
      stage.setScene(scene);
      stage.show();
   }
   
   public void newWindow() {
      Stage window = new Stage();
      VBox root = new VBox(10.0);
      root.setPadding(new Insets(20.0));
      Button button1 = new Button("Кнопка 1");
      button1.setId("button1");
      button1.setUserData(1);
      System.out.println((int)button1.getUserData()); // 1
      System.out.println(button1.getId()); // button1
      
      Button button2 = new Button("Кнопка 2");
      button2.setId("button2");
      button2.setUserData(2);
      
      HBox box = new HBox(10.0);
      Button button3 = new Button("Кнопка 3");
      button3.setId("button3");
      button3.setUserData(3);
      Button button4 = new Button("Кнопка 4");
      button4.setId("button4");
      button4.setUserData(4);
      
      Pane pane = new Pane();
      Button button5 = new Button("Кнопка 5");
      button5.setId("button5");
      button5.setUserData(5);
      pane.getChildren().add(button5);
      
      box.getChildren().addAll(button3, button4, pane);

      root.getChildren().addAll(button1, button2, box);
      Scene scene = new Scene(root, 400.0, 300.0, Color.BLACK);
      window.setScene(scene);
      window.setTitle("Заголовок окна");
      window.show();
      
      scene.addEventHandler(ActionEvent.ACTION, event -> {
         if (event.getTarget() instanceof Button) {
            Button b = (Button) event.getTarget();
            System.out.println(b.getText());
            System.out.println(b.getId());
            System.out.println(b.getUserData());
            
            if (b.getId().equals("button1")) {
               Scene s = b.getScene();
               // s = b.sceneProperty().getValue();
               System.out.println("Цвет сцены " + s.getFill());
               
               Stage st = (Stage) s.getWindow();
               // st = (Stage) s.windowProperty().getValue();
               System.out.println(st.getTitle());
               
               Scene s2 = st.getScene();
               System.out.println("Ширина сцены " + s2.getWidth());
               
               Parent r = s2.getRoot();
               for (Node n: r.getChildrenUnmodifiable()) {
                  System.out.println("   - " + n);
               }
               printTreeNodes(r, 1);
               
               Parent p = b.getParent();
               // p = b.parentProperty().getValue();
               System.out.println(p);
               // VBox@178669ac[styleClass=root]
               System.out.println(p.getParent()); // null
               
               Node nd = s.lookup("#button2");
               System.out.println(nd);
               // Button[id=button2, styleClass=button]'Кнопка 2'
               nd = s.lookup(".button");
               System.out.println(nd);
               // Button[id=button1, styleClass=button]'Кнопка 1'
               System.out.println(s.lookup("#button8")); // null
               
               Parent parent = s.lookup("#button3").getParent();
               System.out.println(parent.lookup("#button4"));
               // Button[id=button4, styleClass=button]'Кнопка 4'
               System.out.println(parent.lookup("#button1"));
               // null
               
               Node rootBox = s.getRoot();
               Set<Node> set = rootBox.lookupAll(".button");
               for (Node n: set) {
                  System.out.println(n);
               }
               System.out.println();
               
               rootBox = s.lookup("#button3").getParent();
               for (Node n: rootBox.lookupAll(".button")) {
                  System.out.println(n);
               }
               
            }
            System.out.println("Родители кнопки " + b.getId());
            printParents(b);
         }
      });
   }
   
   public static void printTreeNodes(Parent parent, int level) {
      String s = String.join("", 
                    Collections.nCopies((level - 1) * 3, " "));
      System.out.println(s + "+ " + parent.getClass().getName());
      for (Node node: parent.getChildrenUnmodifiable()) {
         if (node instanceof Parent) {
            printTreeNodes((Parent)node, level + 1);
         }
         else {
            System.out.println(s + "   - " + node.getClass().getName());
         }
      }
   }
   
   public static void printParents(Node node) {
      if (node != null && node.getParent() != null) {
         Node n = node.getParent();
         System.out.print(" - " + n.getClass().getName());
         printParents(n);
      }
      else {
         System.out.println();
      }
   }
}