import java.text.NumberFormat;
import java.util.Locale;

import javafx.application.Application;
import javafx.beans.InvalidationListener;
import javafx.beans.Observable;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ReadOnlyDoubleProperty;
import javafx.beans.property.ReadOnlyDoubleWrapper;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.control.Slider;
import javafx.scene.control.TextField;
import javafx.scene.layout.Pane;
import javafx.scene.layout.VBox;
import javafx.scene.shape.Rectangle;
import javafx.stage.Stage;
import javafx.util.converter.NumberStringConverter;


public class AppProp extends Application {

   public static void main(String[] args) {
      Application.launch(args);
   }
   
   public static void test() {
      DoubleProperty property = new SimpleDoubleProperty();
      System.out.println(property.getValue()); // 0.0
      property.setValue(20.0);
      System.out.println(property.getValue()); // 20.0
      property.set(40.0);
      System.out.println(property.get());      // 40.0

      StringProperty stringProperty = new SimpleStringProperty();
      System.out.println(stringProperty.getValue()); // null
      stringProperty.setValue("Строка");
      System.out.println(stringProperty.getValue()); // Строка
      
      ObjectProperty<Double> objectProperty = new SimpleObjectProperty<>();
      System.out.println(objectProperty.getValue()); // null
      objectProperty.setValue(150.0);
      System.out.println(objectProperty.getValue()); // 150.0
      
      objectProperty.set(40.0);
      System.out.println(objectProperty.get());      // 40.0
      
      ReadOnlyDoubleWrapper wrapper = new ReadOnlyDoubleWrapper(9.0);
      ReadOnlyDoubleProperty propertyReadOnly = wrapper.getReadOnlyProperty();
      // propertyReadOnly.setValue(150.0); // Ошибка
      System.out.println(propertyReadOnly.getValue()); // 9.0
      
      wrapper.setValue(50.0);
      System.out.println(propertyReadOnly.getValue()); // 50.0
   }
   

   public void start(Stage stage) throws Exception {
      VBox root = new VBox(15.0);
      root.setAlignment(Pos.CENTER);
      root.setPadding(new Insets(20.0));
      Button button = new Button("Назначение обработчиков");
      Button button2 = new Button("Связывание");
      Button button3 = new Button("Однонаправленное связывание");
      Button button4 = new Button("Двунаправленное связывание");
      Button button5 = new Button("Выражения");
      
      button.setOnAction(event -> {
         newWindow();
      });
      button2.setOnAction(event -> {
         newWindow2();
      });
      button3.setOnAction(event -> {
         newWindow3();
      });
      button4.setOnAction(event -> {
         newWindow4();
      });
      button5.setOnAction(event -> {
         newWindow5();
      });
      
      root.getChildren().addAll(button, button2, button3, button4, button5);
      Scene scene = new Scene(root, 400.0, 300.0);
      stage.setTitle("Property");
      stage.setScene(scene);
      stage.show();
      
      //test();
   }

   public void newWindow() {
      Stage window = new Stage();
      Pane pane = new Pane();
      
      Rectangle rect = new Rectangle(50.0, 50.0);
      rect.relocate(200.0, 50.0);
      
      Slider slider = new Slider(-150.0, 150.0, 0.0);
      slider.setShowTickMarks(true);
      slider.setShowTickLabels(true);
      slider.setPrefWidth(400.0);
      slider.relocate(50.0, 150.0);
      
      TextField textField = new TextField();
      textField.setPrefWidth(200.0);
      textField.relocate(50.0, 200.0);
      
      slider.valueProperty().addListener((obj, oldValue, newValue) -> {
         rect.setTranslateX(newValue.doubleValue());
      });
      
      ChangeListener<? super Number>
      changeLlistener = new ChangeListener<Number>() {
         @Override
         public void changed(ObservableValue<? extends Number> observable,
                             Number oldValue, Number newValue) {
            textField.setText(newValue.toString());
            /*System.out.println("ChangeListener " + observable.getValue());
            System.out.println("oldValue = " + oldValue);
            System.out.println("newValue = " + newValue);*/
         }
      };
      slider.valueProperty().addListener(changeLlistener);

      InvalidationListener invListener = new InvalidationListener() {
         @Override
         public void invalidated(Observable observable) {
            System.out.println("window invalidated()");
         }
      };
      window.widthProperty().addListener(invListener);
      
      window.widthProperty().addListener(observable -> {
         System.out.println("window.widthProperty()");
         System.out.println(window.getWidth());
      });
      
      Button button = new Button("Удалить обработчики");
      button.relocate(300.0, 200.0);
      button.setOnAction(event -> {
         slider.valueProperty().removeListener(changeLlistener);
         window.widthProperty().removeListener(invListener);
         button.setDisable(true);
      });
      
      pane.getChildren().addAll(rect, slider, textField, button);
      Scene scene = new Scene(pane, 500, 300);
      /*scene.setRoot(pane);
      scene.rootProperty().setValue(pane);
      System.out.println(scene.getRoot());
      System.out.println(scene.rootProperty().getValue());*/
      
      window.setScene(scene);
      window.setTitle("Назначение обработчиков");
      window.show();
   }

   public void newWindow2() {
      Stage window = new Stage();
      Pane pane = new Pane();
      
      Rectangle rect = new Rectangle(50.0, 50.0);
      rect.relocate(200.0, 50.0);
      
      Slider slider = new Slider(-150.0, 150.0, 0.0);
      slider.setShowTickMarks(true);
      slider.setShowTickLabels(true);
      slider.setPrefWidth(400.0);
      slider.relocate(50.0, 150.0);
      
      TextField textField = new TextField();
      textField.setPrefWidth(200.0);
      textField.relocate(50.0, 200.0);
      
      TextField textField2 = new TextField();
      textField2.setPrefWidth(200.0);
      textField2.relocate(50.0, 250.0);
      
      rect.translateXProperty().bindBidirectional(slider.valueProperty());
      textField.textProperty().bindBidirectional(slider.valueProperty(),
                               new NumberStringConverter());
      textField2.textProperty().bindBidirectional(slider.valueProperty(),
                               NumberFormat.getInstance());
      

      rect.setTranslateX(20.0);
      System.out.println(slider.getValue());    // 20.0
      slider.setValue(50.0);
      System.out.println(rect.getTranslateX()); // 50.0
      
      Button button = new Button("Удалить привязку");
      button.relocate(300.0, 200.0);
      button.setOnAction(event -> {
         textField.textProperty().unbindBidirectional(slider.valueProperty());
         textField2.textProperty().unbindBidirectional(slider.valueProperty());
         slider.valueProperty().unbindBidirectional(rect.translateXProperty());
         button.setDisable(true);
      });
      
      pane.getChildren().addAll(rect, slider, textField, textField2, button);
      Scene scene = new Scene(pane, 500, 300);
      
      window.setScene(scene);
      window.setTitle("Связывание");
      window.show();
   }

   public void newWindow3() {
      Stage window = new Stage();
      Pane pane = new Pane();

      Slider slider = new Slider(-150.0, 150.0, 0.0);
      slider.setShowTickMarks(true);
      slider.setShowTickLabels(true);
      slider.setPrefWidth(400.0);
      slider.relocate(50.0, 50.0);
      
      Slider slider2 = new Slider(-150.0, 150.0, 0.0);
      slider2.setShowTickMarks(true);
      slider2.setShowTickLabels(true);
      slider2.setPrefWidth(400.0);
      slider2.relocate(50.0, 150.0);

      System.out.println(slider2.valueProperty().isBound()); // false
      slider2.valueProperty().bind(slider.valueProperty());
      System.out.println(slider2.valueProperty().isBound());  // true
      
      slider2.setValue(10.0); // Эффекта не будет!!!
      System.out.println(slider2.getValue());  // 0.0
      
      slider.setValue(50.0); // OK
      System.out.println(slider2.getValue());  // 50.0
      
      Button button = new Button("Удалить привязку");
      button.relocate(300.0, 200.0);
      button.setOnAction(event -> {
         slider2.valueProperty().unbind();
         button.setDisable(true);
      });
      
      pane.getChildren().addAll(slider, slider2, button);
      Scene scene = new Scene(pane, 500, 300);
      window.setScene(scene);
      window.setTitle("Однонаправленное связывание");
      window.show();
   }
   
   public void newWindow4() {
      Stage window = new Stage();
      Pane pane = new Pane();

      Slider slider = new Slider(-150.0, 150.0, 0.0);
      slider.setShowTickMarks(true);
      slider.setShowTickLabels(true);
      slider.setPrefWidth(400.0);
      slider.relocate(50.0, 50.0);
      
      Slider slider2 = new Slider(-150.0, 150.0, 0.0);
      slider2.setShowTickMarks(true);
      slider2.setShowTickLabels(true);
      slider2.setPrefWidth(400.0);
      slider2.relocate(50.0, 150.0);
      
      System.out.println(slider2.valueProperty().isBound()); // false
      slider2.valueProperty().bindBidirectional(slider.valueProperty());
      System.out.println(slider2.valueProperty().isBound()); // false
      
      Button button = new Button("Удалить привязку");
      button.relocate(300.0, 200.0);
      button.setOnAction(event -> {
         slider2.valueProperty().unbindBidirectional(slider.valueProperty());
         button.setDisable(true);
      });
      
      pane.getChildren().addAll(slider, slider2, button);
      Scene scene = new Scene(pane, 500, 300);
      window.setScene(scene);
      window.setTitle("Двунаправленное связывание");
      window.show();
   }
   
   public void newWindow5() {
      Stage window = new Stage();
      Pane pane = new Pane();

      Slider slider = new Slider(-150.0, 150.0, 0.0);
      slider.setShowTickMarks(true);
      slider.setShowTickLabels(true);
      slider.setPrefWidth(400.0);
      slider.relocate(50.0, 50.0);
      
      Slider slider2 = new Slider(-100.0, 200.0, 0.0);
      slider2.setShowTickMarks(true);
      slider2.setShowTickLabels(true);
      slider2.setPrefWidth(400.0);
      slider2.relocate(50.0, 150.0);
      
      slider2.valueProperty().bind(slider.valueProperty().add(50.0));
      
      Button button = new Button("Удалить привязку");
      button.relocate(300.0, 200.0);
      button.setOnAction(event -> {
         slider2.valueProperty().unbind();
         button.setDisable(true);
      });
      
      TextField textField = new TextField();
      textField.setPrefWidth(200.0);
      textField.relocate(50.0, 250.0);
      
      Button btn = new Button("Получить значение из поля");
      btn.relocate(300.0, 250.0);
      btn.setOnAction(event -> {
         System.out.println(textField.getText());
      });
      
      btn.disableProperty().bind(textField.textProperty().isEmpty());
      
      pane.getChildren().addAll(slider, slider2, button, textField, btn);
      Scene scene = new Scene(pane, 500, 350);
      window.setScene(scene);
      window.setTitle("Выражения");
      window.show();
      
      {
         System.out.println();
         DoubleProperty property = new SimpleDoubleProperty(20.0);
         DoubleProperty property2 = new SimpleDoubleProperty(5.0);

         System.out.println(property.add(10.0f).get()); // 30.0
         System.out.println(property.add(10.0).get()); // 30.0
         System.out.println(property.add(10).get()); // 30.0
         System.out.println(property.add(10l).get()); // 30.0
         System.out.println(property.add(property2).get()); // 25.0

         System.out.println(property.subtract(10).get()); // 10.0
         System.out.println(property.subtract(10l).get()); // 10.0
         System.out.println(property.subtract(10.0f).get()); // 10.0
         System.out.println(property.subtract(10.0).get()); // 10.0
         System.out.println(property.subtract(property2).get()); // 15.0

         System.out.println(property.multiply(10).get()); // 200.0
         System.out.println(property.multiply(10l).get()); // 200.0
         System.out.println(property.multiply(10.0f).get()); // 200.0
         System.out.println(property.multiply(10.0).get()); // 200.0
         System.out.println(property.multiply(property2).get()); // 100.0

         System.out.println(property.divide(10).get()); // 2.0
         System.out.println(property.divide(10l).get()); // 2.0
         System.out.println(property.divide(10.0f).get()); // 2.0
         System.out.println(property.divide(10.0).get()); // 2.0
         System.out.println(property.divide(property2).get()); // 4.0

         System.out.println(property.negate().get()); // -20.0

         System.out.println(property.asObject().get()); // 20.0

         System.out.println(property.intValue()); // 20
         System.out.println(property.longValue()); // 20
         System.out.println(property.floatValue()); // 20.0
         System.out.println(property.doubleValue()); // 20.0

         DoubleProperty doubleProperty = new SimpleDoubleProperty(15.0);
         ObjectProperty<Double> objectProperty = new SimpleObjectProperty<>(5.0);
         objectProperty.bind(doubleProperty.asObject());

         System.out.println(doubleProperty.getValue()); // 15.0
         System.out.println(objectProperty.getValue()); // 15.0
      }
      
      {
         DoubleProperty property = new SimpleDoubleProperty(20.0);
         System.out.println(property.greaterThan(10.0).get());  // true
         System.out.println(property.greaterThan(30).get());    // false
         System.out.println(
                property.greaterThanOrEqualTo(20.0).get());     // true
         System.out.println(
                property.isEqualTo(19.99999, 0.0001).get());    // true
         System.out.println(
                property.isNotEqualTo(19.99999, 0.0001).get()); // false
         System.out.println(property.lessThan(10.0).get());     // false
         System.out.println(property.lessThan(30).get());       // true
         System.out.println(
               property.lessThanOrEqualTo(20.0).get());         // true
      }
      
      {
         DoubleProperty property = new SimpleDoubleProperty(5.023545664);
         System.out.println(property.asString().get());       // 5.023545664
         System.out.println(property.asString("%.3f").get()); // 5,024
         System.out.println(property.asString(
                  new Locale("en", "US"), "%.2f").get());     // 5.02
         System.out.println(property.toString());
         // DoubleProperty [value: 5.023545664]
      }
      
      {
         StringProperty property = new SimpleStringProperty("строка");
         System.out.println(property.getValue()); // строка
         System.out.println(property.get());      // строка
         
         StringProperty property2 = new SimpleStringProperty();
         System.out.println(property2.getValue());        // null
         System.out.println(property2.get());             // null
         System.out.println(
                    "'" + property2.getValueSafe() + "'"); // ''
         System.out.println(
                    "'" + property.getValueSafe() + "'");  // 'строка'
         
         System.out.println(property.isEmpty().get());  // false
         System.out.println(property2.isEmpty().get()); // true
         System.out.println(property.isNotEmpty().get());  // true
         System.out.println(property2.isNotEmpty().get()); // false
         
         System.out.println(property.isNull().get());   // false
         System.out.println(property2.isNull().get());  // true
         System.out.println(property.isNotNull().get());   // true
         System.out.println(property2.isNotNull().get());  // false
         
         System.out.println(property.length().get());   // 6
         System.out.println(property2.length().get());  // 0
         
         System.out.println(property.concat("2").get());  // строка2
         
         System.out.println(property.isEqualTo("строка").get());  // true
         System.out.println(property.isEqualTo("СтРоКа").get());  //false
         
         System.out.println(
                  property.isEqualToIgnoreCase("строка").get());  // true
         System.out.println(
                  property.isEqualToIgnoreCase("СтРоКа").get());  // true
      }
   }
   
}
