

import java.awt.Desktop;
import java.net.URI;

import javafx.animation.PauseTransition;
import javafx.application.Application;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonBar;
import javafx.scene.control.ButtonBar.ButtonData;
import javafx.scene.control.ButtonBase;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ContentDisplay;
import javafx.scene.control.Hyperlink;
import javafx.scene.control.Label;
import javafx.scene.control.RadioButton;
import javafx.scene.control.ScrollPane;
import javafx.scene.control.Toggle;
import javafx.scene.control.ToggleButton;
import javafx.scene.control.ToggleGroup;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.image.PixelWriter;
import javafx.scene.image.WritableImage;
import javafx.scene.layout.Border;
import javafx.scene.layout.BorderStroke;
import javafx.scene.layout.BorderStrokeStyle;
import javafx.scene.layout.BorderWidths;
import javafx.scene.layout.CornerRadii;
import javafx.scene.layout.HBox;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Color;
import javafx.stage.Stage;
import javafx.util.Duration;


public class Buttons extends Application {

   public static void main(String[] args) {
      Application.launch(args);
   }

   public void start(Stage stage) throws Exception {
      VBox root = new VBox(15.0);
      root.setAlignment(Pos.CENTER);
      root.setPadding(new Insets(20.0));
      Button button = new Button("Класс ButtonBase");
      Button button2 = new Button("Класс Hyperlink. Гиперссылка");
      Button button3 = new Button("Класс Button. Командная кнопка");
      Button button4 = new Button("Класс ButtonBar");
      Button button5 = new Button("Класс ToggleButton");
      Button button6 = new Button("Класс RadioButton");
      Button button7 = new Button("Класс CheckBox");
      
      button.setOnAction(event -> {
         newWindow();
      });
      button2.setOnAction(event -> {
         newWindow2();
      });
      button3.setOnAction(event -> {
         newWindow3();
      });
      button4.setOnAction(event -> {
         newWindow4();
      });
      button5.setOnAction(event -> {
         newWindow5();
      });
      button6.setOnAction(event -> {
         newWindow6();
      });
      button7.setOnAction(event -> {
         newWindow7();
         //newWindowCheckBox();
         //newWindowRadioButton();
         //newWindowToggleButton();
         //newWindowButton();
      });
      
      root.getChildren().addAll(button, button2, button3, button4, button5,
                                button6, button7);
      Scene scene = new Scene(root, 400.0, 400.0);
      stage.setTitle("Класс ButtonBase");
      stage.setScene(scene);
      stage.show();
   }

   public void newWindow() {
      Stage window = new Stage();

      VBox pane = new VBox(15.0);
      pane.setPadding(new Insets(20.0));
      pane.setPrefWidth(380.0);
      
      ScrollPane root = new ScrollPane();
      root.setContent(pane);
      
      ButtonBase button = new Button("На_жми меня");
      button.setId("button1");
      button.setOnAction(event -> {
         System.out.println("Нажата кнопка1");
         System.out.println("isArmed(): " + button.isArmed());
         //button.armedProperty();
      });
      pane.getChildren().add(button);
      
      Button button2 = new Button("_Нажать кнопку 1 программно");
      button2.setId("button2");
      button2.setOnAction(new EventHandler<ActionEvent>() {
         @Override
         public void handle(ActionEvent event) {
            System.out.println("Нажата кнопка 2");
            button.fire();
         }
      });
      pane.getChildren().add(button2);
      
      Button button3 = new Button("Кнопка 3");
      button3.setId("button3");
      button3.addEventHandler(ActionEvent.ACTION,
                              new EventHandler<ActionEvent>() {
         @Override
         public void handle(ActionEvent event) {
            System.out.println("Нажата кнопка 3");
         }
      });
      pane.getChildren().add(button3);

      Button button4 = new Button("Нажать кнопк_у 1 программно");
      button4.setId("button4");
      button4.addEventHandler(ActionEvent.ACTION, event -> {
         System.out.println("Нажата кнопка 4");
         button.arm();
         button.requestFocus();
         PauseTransition tr = new PauseTransition(Duration.seconds(1.0));
         tr.setOnFinished(e -> {
            button.fire();
            button.disarm();
         });
         tr.play();
      });
      pane.getChildren().add(button4);
      
      
      Scene scene = new Scene(root, 400, 400);
      window.setScene(scene);
      
      scene.addEventFilter(ActionEvent.ACTION, event -> {
         if (event.getTarget() instanceof Button) {
            Button btn = (Button) event.getTarget();
            System.out.println("scene: нажата кнопка " + btn.getId());
         }
      });
      
      window.setTitle("Класс ButtonBase");
      window.show();
   }

   public void newWindow2() {
      Stage window = new Stage();

      VBox pane = new VBox(2.0);
      pane.setPadding(new Insets(20.0));
      pane.setPrefWidth(380.0);
      
      ScrollPane root = new ScrollPane();
      root.setContent(pane);
      
      Hyperlink hyperlink = new Hyperlink("http://www.google.com");
      hyperlink.setOnAction(event -> {
         System.out.println("Переход по гиперссылке");
         // import java.awt.Desktop;
         if (Desktop.isDesktopSupported()) {
            try {
               Desktop.getDesktop().browse(URI.create("http://www.google.com"));
            } catch (Exception e) {
               System.out.println("Не удалось запустить Web-браузер");
            }
         }
      });
      pane.getChildren().add(hyperlink);
      System.out.println(hyperlink.isVisited());

      Hyperlink hyperlink2 = new Hyperlink();
      hyperlink2.setText("Текст ссылки");
      hyperlink2.setOnAction(event -> {
         System.out.println("Переход по гиперссылке2");
         hyperlink2.setVisited(true);
      });
      pane.getChildren().add(hyperlink2);
      
      Hyperlink hyperlink3 = new Hyperlink("Текст ссылки с изображением",
                   new ImageView(createImage(16, 16, Color.BLUE)));
      hyperlink3.setOnAction(event -> {
         System.out.println("Переход по гиперссылке3");
      });
      pane.getChildren().add(hyperlink3);
      
      Scene scene = new Scene(root, 400, 400);
      window.setScene(scene);
      window.setTitle("Hyperlink");
      window.show();
   }

   public void newWindow3() {
      Stage window = new Stage();

      VBox pane = new VBox(15.0);
      pane.setPadding(new Insets(20.0));
      pane.setPrefWidth(380.0);
      
      ScrollPane root = new ScrollPane();
      root.setContent(pane);
      
      Button button = new Button("На_жми меня");
      button.setOnAction(event -> {
         System.out.println("Нажата кнопка");
      });
      pane.getChildren().add(button);

      Button button2 = new Button();
      button2.setText("Текст с изображением");
      button2.setGraphic(new ImageView(createImage(16, 16, Color.RED)));
      button2.setOnAction(event -> {
         System.out.println("Нажата кнопка2");
      });
      pane.getChildren().add(button2);
      
      Button button3 = new Button("Кнопка 3",
                   new ImageView(createImage(32, 32, Color.RED)));
      button3.setContentDisplay(ContentDisplay.GRAPHIC_ONLY);
      button3.setOnAction(new EventHandler<ActionEvent>() {
         @Override
         public void handle(ActionEvent event) {
            System.out.println("Нажата кнопка3");
         }
      });
      pane.getChildren().add(button3);

      Button button4 = new Button("Кнопка по умолчанию (нажмите <Enter>)");
      System.out.println(button4.isDefaultButton());
      button4.setDefaultButton(true);
      button4.setOnAction(event -> {
         System.out.println("Нажата кнопка по умолчанию");
      });
      pane.getChildren().add(button4);

      Button button5 = new Button("Кнопка Cancel (нажмите <Esc>)");
      System.out.println(button5.isCancelButton());
      button5.setCancelButton(true);
      button5.setOnAction(event -> {
         System.out.println("Нажата кнопка Cancel");
      });
      pane.getChildren().add(button5);
      
      Button button6 = new Button("Кнопка 6");
      button6.setOnAction(event -> {
         System.out.println("Нажата кнопка6");
         button6.setDisable(true);
         PauseTransition tr = new PauseTransition(Duration.seconds(2.0));
         tr.setOnFinished(e -> {
            System.out.println("Операция завершена");
            button6.setDisable(false);
         });
         tr.play();
      });
      pane.getChildren().add(button6);
      
      Scene scene = new Scene(root, 400, 400);
      window.setScene(scene);
      window.setTitle("Класс Button. Командная кнопка");
      window.show();
   }
   
   public void newWindow4() {
      Stage window = new Stage();

      VBox pane = new VBox(15.0);
      pane.setPadding(new Insets(20.0));
      pane.setPrefWidth(380.0);
      
      ScrollPane root = new ScrollPane();
      root.setContent(pane);

      pane.getChildren().add(new Label("Положение в зависимости от ОС"));
      
      Button btnYes = new Button("Yes");
      ButtonBar.setButtonData(btnYes, ButtonData.YES);

      Button btnNo = new Button("No");
      ButtonBar.setButtonData(btnNo, ButtonData.NO);
      
      Button btnCancel = new Button("Cancel");
      ButtonBar.setButtonData(btnCancel, ButtonData.CANCEL_CLOSE);
      
      ButtonBar buttonBar = new ButtonBar();
      buttonBar.getButtons().addAll(btnYes, btnNo, btnCancel);
      pane.getChildren().add(buttonBar);
      
      pane.getChildren().add(new Label("ButtonBar.BUTTON_ORDER_LINUX"));
      
      Button btnYes2 = new Button("Yes");
      ButtonBar.setButtonData(btnYes2, ButtonData.YES);

      Button btnNo2 = new Button("No");
      ButtonBar.setButtonData(btnNo2, ButtonData.NO);
      
      Button btnCancel2 = new Button("Cancel");
      ButtonBar.setButtonData(btnCancel2, ButtonData.CANCEL_CLOSE);
      
      ButtonBar buttonBar2 = new ButtonBar();
      buttonBar2.setButtonOrder(ButtonBar.BUTTON_ORDER_LINUX);
      System.out.println(buttonBar2.getButtonMinWidth());
      buttonBar2.setButtonMinWidth(100.0);
      
      buttonBar2.getButtons().addAll(btnYes2, btnNo2, btnCancel2);
      pane.getChildren().add(buttonBar2);
      
      pane.getChildren().add(new Label("ButtonBar.BUTTON_ORDER_MAC_OS"));
      
      Button btnYes3 = new Button("Yes");
      ButtonBar.setButtonData(btnYes3, ButtonData.YES);
      
      Button btnNo3 = new Button("No");
      ButtonBar.setButtonData(btnNo3, ButtonData.NO);
      
      Button btnCancel3 = new Button("Cancel");
      ButtonBar.setButtonData(btnCancel3, ButtonData.CANCEL_CLOSE);
      
      ButtonBar buttonBar3 = new ButtonBar(ButtonBar.BUTTON_ORDER_MAC_OS);
      buttonBar3.getButtons().addAll(btnYes3, btnNo3, btnCancel3);
      pane.getChildren().add(buttonBar3);
      
      pane.getChildren().add(new Label("ButtonBar.BUTTON_ORDER_NONE"));
      
      Button btnYes4 = new Button("Yes");
      ButtonBar.setButtonData(btnYes4, ButtonData.YES);
      btnYes4.setPrefWidth(150.0);
      ButtonBar.setButtonUniformSize(btnYes4, false);
      System.out.println(ButtonBar.isButtonUniformSize(btnYes4));
      
      Button btnNo4 = new Button("No");
      ButtonBar.setButtonData(btnNo4, ButtonData.NO);
      
      Button btnCancel4 = new Button("Cancel");
      ButtonBar.setButtonData(btnCancel4, ButtonData.CANCEL_CLOSE);
      
      ButtonBar buttonBar4 = new ButtonBar();
      buttonBar4.setButtonOrder(ButtonBar.BUTTON_ORDER_NONE);
      buttonBar4.getButtons().addAll(btnCancel4, btnYes4, btnNo4);
      pane.getChildren().add(buttonBar4);
      
      Scene scene = new Scene(root, 400, 400);
      window.setScene(scene);
      window.setTitle("Класс ButtonBar");
      window.show();
      
      System.out.println(ButtonBar.getButtonData(btnYes));
      // YES
      System.out.println(ButtonData.YES.getTypeCode()); // Y

      System.out.println(ButtonBar.BUTTON_ORDER_NONE.length());
      // 0
      System.out.println(ButtonBar.BUTTON_ORDER_WINDOWS);
      // L_E+U+FBXI_YNOCAH_R
      System.out.println(ButtonBar.BUTTON_ORDER_LINUX);
      // L_HE+UNYACBXIO_R
      System.out.println(ButtonBar.BUTTON_ORDER_MAC_OS);
      // L_HE+U+FBIX_NCYOA_R
   }
   
   public void newWindow5() {
      Stage window = new Stage();

      VBox pane = new VBox(15.0);
      pane.setPadding(new Insets(20.0));
      pane.setPrefWidth(480.0);
      
      ScrollPane root = new ScrollPane();
      root.setContent(pane);

      ToggleButton button = new ToggleButton("Текст на кнопке");
      button.selectedProperty().addListener((obj, oldValue, newValue) -> {
         System.out.println("button selected = " + newValue);
      });
      button.setOnAction(event -> {
         if (button.isSelected()) {
            System.out.println("Переключатель включен");
         }
         else {
            System.out.println("Переключатель выключен");
         }
      });
      pane.getChildren().add(button);
      
      ToggleButton button2 = new ToggleButton();
      button2.setText("Текст на кнопке 2");
      button2.setOnAction(event -> {
         System.out.println("Нажата кнопка 2");
      });
      pane.getChildren().add(button2);
      
      ToggleButton button3 = new ToggleButton("Текст на кнопке 3", 
                   new ImageView(createImage(16, 16, Color.CHOCOLATE)));
      button3.setOnAction(event -> {
         System.out.println("Нажата кнопка 3");
      });
      pane.getChildren().add(button3);

      ToggleButton btn = new ToggleButton("Переключатель 1");
      btn.setId("btn");
      ToggleButton btn2 = new ToggleButton("Переключатель 2");
      btn2.setId("btn2");
      ToggleButton btn3 = new ToggleButton("Переключатель 3");
      btn3.setId("btn3");
      HBox hbox = new HBox(10.0);
      hbox.getChildren().addAll(btn, btn2, btn3);
      hbox.setPadding(new Insets(15.0));
      hbox.setAlignment(Pos.CENTER);
      hbox.setBorder(new Border(
               new BorderStroke(Color.SILVER, BorderStrokeStyle.SOLID,
               CornerRadii.EMPTY, new BorderWidths(1.0), new Insets(0.0))));
      
      ToggleGroup group = new ToggleGroup();
      btn.setToggleGroup(group);
      btn2.setToggleGroup(group);
      btn3.setToggleGroup(group);
      //group.getToggles().addAll(btn, btn2, btn3);
      group.selectToggle(btn);
      
      group.selectedToggleProperty().addListener((obj, oldValue, newValue) -> {
         if (newValue instanceof ToggleButton) {
            System.out.println("group selected = " + 
                               ((ToggleButton)newValue).getId());
         }
      });
      
      pane.getChildren().add(hbox);
      
      Scene scene = new Scene(root, 500, 400);
      window.setScene(scene);
      window.setTitle("Класс ToggleButton");
      window.show();
   }
   
   public void newWindow6() {
      Stage window = new Stage();

      VBox pane = new VBox(15.0);
      pane.setPadding(new Insets(20.0));
      pane.setPrefWidth(480.0);
      
      ScrollPane root = new ScrollPane();
      root.setContent(pane);

      RadioButton button = new RadioButton("Текст");
      button.selectedProperty().addListener((obj, oldValue, newValue) -> {
         System.out.println("button selected = " + newValue);
      });
      button.setOnAction(event -> {
         if (button.isSelected()) {
            System.out.println("Переключатель включен");
         }
         else {
            System.out.println("Переключатель выключен");
         }
      });
      pane.getChildren().add(button);
      
      RadioButton button2 = new RadioButton();
      button2.setText("Текст");
      button2.setOnAction(event -> {
         System.out.println("Нажата кнопка 2");
      });
      pane.getChildren().add(button2);
      
      RadioButton button3 = new RadioButton("Текст");
      button3.setGraphic(new ImageView(createImage(16, 16, Color.CHOCOLATE)));
      button3.setOnAction(event -> {
         System.out.println("Нажата кнопка 3");
      });
      pane.getChildren().add(button3);
      
      RadioButton btn = new RadioButton("Переключатель 1");
      btn.setUserData("btn");
      RadioButton btn2 = new RadioButton("Переключатель 2");
      btn2.setUserData("btn2");
      RadioButton btn3 = new RadioButton("Переключатель 3");
      btn3.setUserData("btn3");
      
      HBox hbox = new HBox(10.0);
      hbox.getChildren().addAll(btn, btn2, btn3);
      
      hbox.setPadding(new Insets(15.0));
      hbox.setAlignment(Pos.CENTER);
      hbox.setBorder(new Border(
               new BorderStroke(Color.SILVER, BorderStrokeStyle.SOLID,
               CornerRadii.EMPTY, new BorderWidths(1.0), new Insets(0.0))));
      
      ToggleGroup group = new ToggleGroup();
      btn.setToggleGroup(group);
      btn2.setToggleGroup(group);
      btn3.setToggleGroup(group);
      
      //group.getToggles().addAll(btn, btn2, btn3);
      group.selectToggle(btn);
      System.out.println(group.hasProperties()); // false
      group.setUserData(1);
      System.out.println(group.getUserData());   // 1
      System.out.println(group.hasProperties()); // true
      group.getProperties().put(btn, 2);
      group.getProperties().entrySet().forEach(n -> {
         System.out.println(n);
      });
      
      System.out.println();
      for (Toggle t: group.getToggles()) {
         System.out.println(t);
      }
      
      group.selectedToggleProperty().addListener((obj, oldValue, newValue) -> {
         if (newValue instanceof Toggle) {
            System.out.println("group selected = " + newValue.getUserData());
         }
      });
      
      pane.getChildren().add(hbox);
      
      Scene scene = new Scene(root, 500, 400);
      window.setScene(scene);
      window.setTitle("Класс RadioButton");
      window.show();
   }
   
   public void newWindow7() {
      Stage window = new Stage();

      VBox pane = new VBox(15.0);
      pane.setPadding(new Insets(20.0));
      pane.setPrefWidth(480.0);
      
      ScrollPane root = new ScrollPane();
      root.setContent(pane);

      CheckBox checkBox = new CheckBox("Текст рядом с флажком");
      checkBox.setAllowIndeterminate(true);
      checkBox.setIndeterminate(true);
      checkBox.selectedProperty().addListener((obj, oldValue, newValue) -> {
         System.out.println("checkBox selected = " + newValue);
      });
      checkBox.indeterminateProperty().addListener(
         (obj, oldValue, newValue) -> {
            System.out.println("checkBox indeterminate = " + newValue);
      });
      Button button = new Button("Проверить статус флажка");
      button.setOnAction(event -> {
         if (checkBox.isIndeterminate()) {
            System.out.println("Флажок в неопределенном состоянии");
         }
         else {
            if (checkBox.isSelected()) {
               System.out.println("Флажок установлен");
            }
            else {
               System.out.println("Флажок сброшен");
            }
         }
      });
      pane.getChildren().add(new HBox(15.0, checkBox, button));
      
      CheckBox checkBox2 = new CheckBox();
      checkBox2.setText("Текст");
      checkBox2.setOnAction(event -> {
         System.out.println("Нажат checkBox2");
      });
      pane.getChildren().add(checkBox2);
      
      CheckBox checkBox3 = new CheckBox("Текст");
      checkBox3.setSelected(true);
      checkBox3.setGraphic(new ImageView(createImage(16, 16, Color.CHOCOLATE)));
      checkBox3.setOnAction(event -> {
         System.out.println("Нажат checkBox3");
      });
      pane.getChildren().add(checkBox3);

      Scene scene = new Scene(root, 500, 400);
      window.setScene(scene);
      window.setTitle("Класс CheckBox");
      window.show();
   }
   
   public static Image createImage(int width, int height, Color color) {
      if (width < 1) width = 5;
      if (height < 1) height = 5;
      if (color == null) color = Color.BLACK;

      WritableImage wim = new WritableImage(width, height);
      PixelWriter pw = wim.getPixelWriter();
      for (int x = 0; x < width; x++) {
         for (int y = 0; y < height; y++) {
            pw.setColor(x, y, color);
         }
       }
      return wim;
   }
   
   public void newWindowCheckBox() {
      Stage window = new Stage();

      HBox pane = new HBox(10.0);
      pane.setAlignment(Pos.CENTER);
      pane.setPadding(new Insets(20.0));

      CheckBox checkBox = new CheckBox("Флажок сброшен");
      CheckBox checkBox2 = new CheckBox("Флажок установлен");
      checkBox2.setSelected(true);
      CheckBox checkBox3 = new CheckBox("Indeterminate");
      checkBox3.setAllowIndeterminate(true);
      checkBox3.setIndeterminate(true);
      
      pane.getChildren().addAll(checkBox, checkBox2, checkBox3);

      Scene scene = new Scene(pane, 450, 60);
      window.setScene(scene);
      window.setTitle("Класс CheckBox");
      window.show();
   }
   
   public void newWindowRadioButton() {
      Stage window = new Stage();

      HBox pane = new HBox(10.0);
      pane.setAlignment(Pos.CENTER);
      pane.setPadding(new Insets(20.0));

      RadioButton radioButton = new RadioButton("Переключатель выключен");
      RadioButton radioButton2 = new RadioButton("Переключатель включен");
      radioButton2.setSelected(true);
      
      pane.getChildren().addAll(radioButton, radioButton2);

      Scene scene = new Scene(pane, 450, 60);
      window.setScene(scene);
      window.setTitle("Класс RadioButton");
      window.show();
   }
   
   public void newWindowToggleButton() {
      Stage window = new Stage();

      HBox pane = new HBox(10.0);
      pane.setAlignment(Pos.CENTER);
      pane.setPadding(new Insets(20.0));

      ToggleButton toggleButton = new ToggleButton("Переключатель выключен");
      ToggleButton toggleButton2 = new ToggleButton("Переключатель включен");
      toggleButton2.setSelected(true);
      
      pane.getChildren().addAll(toggleButton, toggleButton2);

      Scene scene = new Scene(pane, 450, 60);
      window.setScene(scene);
      window.setTitle("Класс ToggleButton");
      window.show();
   }
   
   public void newWindowButton() {
      Stage window = new Stage();

      HBox pane = new HBox(10.0);
      pane.setAlignment(Pos.CENTER);
      pane.setPadding(new Insets(20.0));

      Button button = new Button("Только текст");
      Button button2 = new Button("Текст с изображением");
      button2.setGraphic(new ImageView(createImage(16, 16, Color.DARKGRAY)));
      Button button3 = new Button("Текст с изображением");
      button3.setGraphic(new ImageView(createImage(16, 16, Color.DARKGRAY)));
      button3.setContentDisplay(ContentDisplay.GRAPHIC_ONLY);
      
      pane.getChildren().addAll(button, button2, button3);

      Scene scene = new Scene(pane, 450, 60);
      window.setScene(scene);
      window.setTitle("Класс Button");
      window.show();
   }
}
