/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.jdbc.field;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.sql.SQLException;
import org.firebirdsql.encodings.CharacterTranslator;
import org.firebirdsql.encodings.EncodingFactory;
import org.firebirdsql.jdbc.FBSQLException;

final class TranslatingReader
extends InputStreamReader {
    private final CharacterTranslator mapping;

    static Reader getInstance(InputStream in, String charsetName, String mappingPath) throws SQLException {
        CharacterTranslator mapping = EncodingFactory.getTranslator(mappingPath);
        try {
            if (charsetName != null) {
                if (mapping != null) {
                    return new TranslatingReader(in, charsetName, mapping);
                }
                return new InputStreamReader(in, charsetName);
            }
            if (mapping != null) {
                return new TranslatingReader(in, mapping);
            }
            return new InputStreamReader(in);
        }
        catch (UnsupportedEncodingException ex) {
            throw new FBSQLException("Cannot set character stream because the unsupported encoding is detected in the JVM: " + charsetName + ". Please report this to the driver developers.");
        }
    }

    private TranslatingReader(InputStream in, String charsetName, CharacterTranslator mapping) throws UnsupportedEncodingException, SQLException {
        super(in, charsetName);
        assert (mapping != null) : "mapping is required";
        this.mapping = mapping;
    }

    private TranslatingReader(InputStream in, CharacterTranslator mapping) throws UnsupportedEncodingException, SQLException {
        super(in);
        assert (mapping != null) : "mapping is required";
        this.mapping = mapping;
    }

    @Override
    public int read() throws IOException {
        int valueRead = super.read();
        if (valueRead == -1) {
            return -1;
        }
        return this.mapping.getMapping((char)super.read());
    }

    @Override
    public int read(char[] cbuf, int offset, int length) throws IOException {
        int result = super.read(cbuf, offset, length);
        if (result == -1) {
            return -1;
        }
        for (int i = offset; i < offset + result; ++i) {
            cbuf[i] = this.mapping.getMapping(cbuf[i]);
        }
        return result;
    }
}

