#ifndef PT4H
#define PT4H
#include <windows.h>
#include <string>
#include <iterator>
#include <vector>
#include <deque>
#include <list>
#include <set>
#include <map>

struct Node;

typedef Node TNode;
typedef Node *PNode;

void DeleteNode(PNode p);

struct Node
{
    int Data;
    Node *Next;
    Node *Prev;
    Node *Left;
    Node *Right;
    Node *Parent;
    static void operator delete(void *p)
    {
        DeleteNode((PNode)p);
    }
};

void Task(const char *Name);

DWORD Filter(DWORD dw);
class PTIO
{
};

PTIO &operator<<(PTIO &p, bool a);
PTIO &operator<<(PTIO &p, int a);
PTIO &operator<<(PTIO &p, double a);
PTIO &operator<<(PTIO &p, char a);
PTIO &operator<<(PTIO &p, const char *a);
PTIO &operator<<(PTIO &p, std::string a);
PTIO &operator<<(PTIO &p, PNode a);

PTIO &operator>>(PTIO &p, bool &a);
PTIO &operator>>(PTIO &p, int &a);
PTIO &operator>>(PTIO &p, double &a);
PTIO &operator>>(PTIO &p, char &a);
PTIO &operator>>(PTIO &p, char *a);
PTIO &operator>>(PTIO &p, std::string &a);
PTIO &operator>>(PTIO &p, PNode &a);

void PutB(bool a);
void PutN(int a);
void PutD(double a);
void PutC(char a);
void PutS(const char *a);
void PutS(std::string a);
void PutP(PNode a);

void GetB(bool *a);
void GetN(int *a);
void GetD(double *a);
void GetC(char *a);
void GetS(char *a);
void GetS(std::string &a);
void GetP(PNode *a);

bool GetBool();
int GetInt();
double GetDouble();
char GetChar();
std::string GetString();
PNode GetNode();

extern PTIO pt;

void raisePT(const char *, const char *);

void ShowB(bool b);
void ShowN(int n);
void ShowD(double d);
void ShowC(char c);
void ShowS(const char *s);
void ShowS(std::string s);
void ShowCmt(const char *cmt);
void ShowCmt(std::string cmt);
void ShowWCmt(const wchar_t *cmt);
void ShowWCmt(std::wstring cmt);
void ShowLine(void);

void RuAnsi(char *result, const wchar_t *source);
std::string RuAnsi(const wchar_t *source);
std::string RuAnsi(std::wstring source);

void SetPrecision(int n);
void SetWidth(int n);
void SetW(int n);
void HideTask(void);

void Show(const char *cmt, bool b, int w = -1);
void Show(const char *cmt, int n, int w = -1);
void Show(const char *cmt, double d, int w = -1);
void Show(const char *cmt, char c, int w = -1);
void Show(const char *cmt, const char *s, int w = -1);
void Show(const char *cmt, std::string s, int w = -1);

void Show(std::string cmt, bool b, int w = -1);
void Show(std::string cmt, int n, int w = -1);
void Show(std::string cmt, double d, int w = -1);
void Show(std::string cmt, char c, int w = -1);
void Show(std::string cmt, const char *s, int w = -1);
void Show(std::string cmt, std::string s, int w = -1);

void Show(const wchar_t *cmt, bool b, int w = -1);
void Show(const wchar_t *cmt, int n, int w = -1);
void Show(const wchar_t *cmt, double d, int w = -1);
void Show(const wchar_t *cmt, char c, int w = -1);
void Show(const wchar_t *cmt, const char *s, int w = -1);
void Show(const wchar_t *cmt, std::string s, int w = -1);

void Show(std::wstring cmt, bool b, int w = -1);
void Show(std::wstring cmt, int n, int w = -1);
void Show(std::wstring cmt, double d, int w = -1);
void Show(std::wstring cmt, char c, int w = -1);
void Show(std::wstring cmt, const char *s, int w = -1);
void Show(std::wstring cmt, std::string s, int w = -1);

void Show(bool b, int w = -1);
void Show(int n, int w = -1);
void Show(double d, int w = -1);
void Show(char c, int w = -1);
void Show(const char *s, int w = -1);
void Show(std::string s, int w = -1);

void ShowLine(const char *cmt, bool b, int w = -1);
void ShowLine(const char *cmt, int n, int w = -1);
void ShowLine(const char *cmt, double d, int w = -1);
void ShowLine(const char *cmt, char c, int w = -1);
void ShowLine(const char *cmt, const char *s, int w = -1);
void ShowLine(const char *cmt, std::string s, int w = -1);

void ShowLine(std::string cmt, bool b, int w = -1);
void ShowLine(std::string cmt, int n, int w = -1);
void ShowLine(std::string cmt, double d, int w = -1);
void ShowLine(std::string cmt, char c, int w = -1);
void ShowLine(std::string cmt, const char *s, int w = -1);
void ShowLine(std::string cmt, std::string s, int w = -1);

void ShowLine(const wchar_t *cmt, bool b, int w = -1);
void ShowLine(const wchar_t *cmt, int n, int w = -1);
void ShowLine(const wchar_t *cmt, double d, int w = -1);
void ShowLine(const wchar_t *cmt, char c, int w = -1);
void ShowLine(const wchar_t *cmt, const char *s, int w = -1);
void ShowLine(const wchar_t *cmt, std::string s, int w = -1);

void ShowLine(std::wstring cmt, bool b, int w = -1);
void ShowLine(std::wstring cmt, int n, int w = -1);
void ShowLine(std::wstring cmt, double d, int w = -1);
void ShowLine(std::wstring cmt, char c, int w = -1);
void ShowLine(std::wstring cmt, const char *s, int w = -1);
void ShowLine(std::wstring cmt, std::string s, int w = -1);

void ShowLine(bool b, int w = -1);
void ShowLine(int n, int w = -1);
void ShowLine(double d, int w = -1);
void ShowLine(char c, int w = -1);
void ShowLine(const char *s, int w = -1);
void ShowLine(std::string s, int w = -1);

template <typename T1, typename T2>
PTIO &operator<<(PTIO &p, const std::pair<T1, T2> &a);

template <typename T>
PTIO &operator<<(PTIO &p, const std::vector<T> &a);

template <typename T>
PTIO &operator<<(PTIO &p, const std::deque<T> &a);

template <typename T>
PTIO &operator<<(PTIO &p, const std::list<T> &a);

template <typename T, typename Comp>
PTIO &operator<<(PTIO &p, const std::set<T, Comp> &a);

template <typename T, typename Comp>
PTIO &operator<<(PTIO &p, const std::multiset<T, Comp> &a);

template <typename T1, typename T2, typename Comp>
PTIO &operator<<(PTIO &p, const std::map<T1, T2, Comp> &a);

template <typename T1, typename T2, typename Comp>
PTIO &operator<<(PTIO &p, const std::multimap<T1, T2, Comp> &a);

template <typename T>
class ptin_iterator : public std::iterator<std::input_iterator_tag, T>
{
private:
    int state_;
    bool end_;
    T value_;

    void getNext()
    {
        end_ = state_ == 0;
        if (end_)
            return;
        --state_;
        pt >> value_;
    }

public:
    bool operator==(const ptin_iterator &it) const
    {
        return end_ && end_ == it.end_;
    }

    bool operator!=(const ptin_iterator &it) const
    {
        return !(*this == it);
    }

    ptin_iterator(int count) : value_(T())
    {
        state_ = count;
        if (state_ == 0)
            pt >> state_;
        if (state_ < 0)
            state_ = 0;
        getNext();
    }

    ptin_iterator() : state_(0), end_(true), value_(T())
    {
    }

    const T &operator*()
    {
        return value_;
    }

    const T *operator->()
    {
        return &value_;
    }

    ptin_iterator &operator++()
    {
        getNext();
        return *this;
    }

    ptin_iterator operator++(int)
    {
        ptin_iterator<T> prev = *this;
        getNext();
        return prev;
    }
};

template <typename T>
class ptout_iterator : public std::iterator<std::output_iterator_tag, T>
{
public:
    ptout_iterator &operator*()
    {
        return *this;
    }

    ptout_iterator &operator=(const T &value)
    {
        pt << value;
        return *this;
    }

    ptout_iterator &operator++()
    {
        return *this;
    }

    ptout_iterator &operator++(int)
    {
        return *this;
    }
};

template <typename T>
void Show(std::vector<T> &cont);
template <typename T>
void Show(std::deque<T> &cont);
template <typename T>
void Show(std::list<T> &cont);
template <typename T, typename Comp>
void Show(std::set<T, Comp> &cont);
template <typename T, typename Comp>
void Show(std::multiset<T, Comp> &cont);
template <typename T1, typename T2, typename Comp>
void Show(std::map<T1, T2, Comp> &cont);
template <typename T1, typename T2, typename Comp>
void Show(std::multimap<T1, T2, Comp> &cont);

template <typename T1, typename T2>
void Show(std::pair<T1, T2> &a)
{
    ShowCmt("(");
    Show(a.first);
    ShowCmt(",");
    Show(a.second);
    ShowCmt(")");
}

template <typename T1, typename T2>
void ShowLine(std::pair<T1, T2> &a)
{
    ShowCmt("(");
    Show(a.first);
    ShowCmt(",");
    Show(a.second);
    ShowCmt(")\n");
}

template <typename T1, typename T2>
void Show(const char *cmt, std::pair<T1, T2> &a)
{
    ShowCmt(cmt);
    ShowCmt("(");
    Show(a.first);
    ShowCmt(",");
    Show(a.second);
    ShowCmt(")");
}

template <typename T1, typename T2>
void Show(std::string cmt, std::pair<T1, T2> &a)
{
    ShowCmt(cmt);
    ShowCmt("(");
    Show(a.first);
    ShowCmt(",");
    Show(a.second);
    ShowCmt(")");
}

template <typename T1, typename T2>
void Show(const wchar_t *cmt, std::pair<T1, T2> &a)
{
    ShowWCmt(cmt);
    ShowCmt("(");
    Show(a.first);
    ShowCmt(",");
    Show(a.second);
    ShowCmt(")");
}

template <typename T1, typename T2>
void Show(std::wstring cmt, std::pair<T1, T2> &a)
{
    ShowWCmt(cmt);
    ShowCmt("(");
    Show(a.first);
    ShowCmt(",");
    Show(a.second);
    ShowCmt(")");
}

template <typename T1, typename T2>
void ShowLine(const char *cmt, std::pair<T1, T2> &a)
{
    ShowCmt(cmt);
    ShowCmt("(");
    Show(a.first);
    ShowCmt(",");
    Show(a.second);
    ShowCmt(")\n");
}

template <typename T1, typename T2>
void ShowLine(std::string cmt, std::pair<T1, T2> &a)
{
    ShowCmt(cmt);
    ShowCmt("(");
    Show(a.first);
    ShowCmt(",");
    Show(a.second);
    ShowCmt(")\n");
}

template <typename T1, typename T2>
void ShowLine(const wchar_t *cmt, std::pair<T1, T2> &a)
{
    ShowWCmt(cmt);
    ShowCmt("(");
    Show(a.first);
    ShowCmt(",");
    Show(a.second);
    ShowCmt(")\n");
}

template <typename T1, typename T2>
void ShowLine(std::wstring cmt, std::pair<T1, T2> &a)
{
    ShowWCmt(cmt);
    ShowCmt("(");
    Show(a.first);
    ShowCmt(",");
    Show(a.second);
    ShowCmt(")\n");
}

template <typename InIter>
void Show(InIter first, InIter last)
{
    for (; first != last;)
        Show(*first++);
    ShowLine();
}

template <typename InIter>
void Show(InIter first, InIter last, const char *cmt)
{
    ShowCmt(cmt);
    for (; first != last;)
        Show(*first++);
    ShowLine();
}

template <typename InIter>
void Show(InIter first, InIter last, std::string cmt)
{
    ShowCmt(cmt);
    for (; first != last;)
        Show(*first++);
    ShowLine();
}

template <typename InIter>
void Show(InIter first, InIter last, const wchar_t *cmt)
{
    ShowWCmt(cmt);
    for (; first != last;)
        Show(*first++);
    ShowLine();
}

template <typename InIter>
void Show(InIter first, InIter last, std::wstring cmt)
{
    ShowWCmt(cmt);
    for (; first != last;)
        Show(*first++);
    ShowLine();
}

template <typename InIter>
void ShowLine(InIter first, InIter last)
{
    for (; first != last;)
    {
        Show(*first++);
        ShowLine();
    }
}

template <typename InIter>
void ShowLine(InIter first, InIter last, const char *cmt)
{
    ShowCmt(cmt);
    ShowLine();
    for (; first != last;)
    {
        Show(*first++);
        ShowLine();
    }
}

template <typename InIter>
void ShowLine(InIter first, InIter last, std::string cmt)
{
    ShowCmt(cmt);
    ShowLine();
    for (; first != last;)
    {
        Show(*first++);
        ShowLine();
    }
}

template <typename InIter>
void ShowLine(InIter first, InIter last, const wchar_t *cmt)
{
    ShowWCmt(cmt);
    ShowLine();
    for (; first != last;)
    {
        Show(*first++);
        ShowLine();
    }
}

template <typename InIter>
void ShowLine(InIter first, InIter last, std::wstring cmt)
{
    ShowWCmt(cmt);
    ShowLine();
    for (; first != last;)
    {
        Show(*first++);
        ShowLine();
    }
}

template <typename T>
void Show(std::vector<T> &cont)
{
    for (auto e : cont)
        Show(e);
}

template <typename T>
void Show(std::deque<T> &cont)
{
    for (auto e : cont)
        Show(e);
}

template <typename T>
void Show(std::list<T> &cont)
{
    for (auto e : cont)
        Show(e);
}

template <typename T, typename Comp>
void Show(std::set<T, Comp> &cont)
{
    for (auto e : cont)
        Show(e);
}

template <typename T, typename Comp>
void Show(std::multiset<T, Comp> &cont)
{
    for (auto e : cont)
        Show(e);
}

template <typename T1, typename T2, typename Comp>
void Show(std::map<T1, T2, Comp> &cont)
{
    for (auto e : cont)
        Show(e);
}

template <typename T1, typename T2, typename Comp>
void Show(std::multimap<T1, T2, Comp> &cont)
{
    for (auto e : cont)
        Show(e);
}


template <typename T1, typename T2>
PTIO &operator<<(PTIO &p, const std::pair<T1, T2> &a)
{
    return p << a.first << a.second;
}

template <typename T>
PTIO &operator<<(PTIO &p, const std::vector<T> &a)
{
    for (auto e : a)
        p << e;
    return p;
}

template <typename T>
PTIO &operator<<(PTIO &p, const std::deque<T> &a)
{
    for (auto e : a)
        p << e;
    return p;
}

template <typename T>
PTIO &operator<<(PTIO &p, const std::list<T> &a)
{
    for (auto e : a)
        p << e;
    return p;
}

template <typename T, typename Comp>
PTIO &operator<<(PTIO &p, const std::set<T, Comp> &a)
{
    for (auto e : a)
        p << e;
    return p;
}

template <typename T, typename Comp>
PTIO &operator<<(PTIO &p, const std::multiset<T, Comp> &a)
{
    for (auto e : a)
        p << e;
    return p;
}

template <typename T1, typename T2, typename Comp>
PTIO &operator<<(PTIO &p, const std::map<T1, T2, Comp> &a)
{
    for (auto e : a)
        p << e;
    return p;
}

template <typename T1, typename T2, typename Comp>
PTIO &operator<<(PTIO &p, const std::multimap<T1, T2, Comp> &a)
{
    for (auto e : a)
        p << e;
    return p;
}

void Solve();

#include "seh.h"
int main()
{
    try
    {
        __seh_try { Solve(); }
        __seh_except(Filter(GetExceptionCode1())) {}
        __seh_end_except
    }
    catch (const std::exception &e)
    {
        raisePT(e.what(), "");
    }
    return 0;
}

#define MPICH_SKIP_MPICXX 1

std::string GetExename();

#endif
