
import matplotlib.pyplot as plt
import random
from math import sqrt

POINT_N = 300
DIM_N = 2
CLUST_N = 1

class POINT:
    def __init__(self, cl, x, y):
        self.cl = cl
        self.X = x
        self.Y = y

class CLUSTER:
    def __init__(self, ind, cl, x, y):
        self.point = [ind]
        self.clust = cl
        self.N = 1
        self.Sx = self.X = x
        self.Sy = self.Y = y
        self.Sxx = x*x
        self.Syy = y*y
    def Dist2(self, p):
        return (self.X - p.X)**2 + (self.Y - p.Y)**2
    def Merge(self, C):
        self.point.extend(C.point)
        self.N += C.N
        self.Sx += C.Sx
        self.Sy += C.Sy
        self.X = self.Sx/self.N
        self.Y = self.Sy/self.N
        self.Sxx += C.Sxx
        self.Syy += C.Syy

#r = random.random()
#r = 0.4517159940083255 # anomaly for DataClouds(..., 100)
#print(r, '\n')
random.seed()

PP = [POINT(0, 0.0, 0.0) for i in range(0, POINT_N)]

cl = [[0.0, 0.0], [10.0, 0.0], [0.0, 10.0]]
for i in range(0, POINT_N):
	r = random.random()
	for c in range(0, CLUST_N):
		if r <= (c+1)/CLUST_N:
			PP[i].cl = c
			PP[i].X = random.normalvariate(cl[c][0], 1.0)
			PP[i].Y = random.normalvariate(cl[c][1], 1.0)
			break;

CC = [CLUSTER(i, i, PP[i].X, PP[i].Y) for i in range(0, POINT_N)]
ClustN = POINT_N

DD = []
dSigma = []
for i in range(0, ClustN):
    dd = []
    for j in range(0, i):
#        dd.append(sqrt(CC[i].Dist2(CC[j])))                    # Centroid
        dd.append( CC[i].Dist2(CC[j]) * CC[i].N*CC[j].N/(CC[i].N+CC[j].N)/(CC[i].N+CC[j].N) )     # Word
    DD.append(dd)

dSigma = []
while ClustN > CLUST_N:
    i0 = 1
    j0 = 0
    d = DD[i0][j0]
    for i in range(1, ClustN):
        for j in range(0, i):
            if DD[i][j] < d:
                d = DD[i][j]
                i0 = i
                j0 = j

#    if CC[i0].N>1 or CC[j0].N>1:
#        dA = CC[i0].Sxx/CC[i0].N - CC[i0].X*CC[i0].X
#        dA += CC[i0].Syy/CC[i0].N - CC[i0].Y*CC[i0].Y
#        dB = CC[j0].Sxx/CC[j0].N - CC[j0].X*CC[j0].X
#        dB += CC[j0].Syy/CC[j0].N - CC[j0].Y*CC[j0].Y
    dSigma.append(d)
    CC[i0].Merge(CC[j0])

    for i in range(i0+1, ClustN):
#        DD[i][i0] = sqrt(CC[i0].Dist2(CC[i]))                  # Centroid
        DD[i][i0] = CC[i0].Dist2(CC[i]) * CC[i0].N*CC[i].N/(CC[i0].N+CC[i].N)/(CC[i0].N+CC[i].N)            # Ward s method
#        DD[i][i0] = min(DD[i][i0], DD[i][j0])          # Nearest points
    for j in range(0, i0):
#        DD[i0][j] = sqrt(CC[i0].Dist2(CC[j]))                  # Centroid
        DD[i0][j] = CC[i0].Dist2(CC[j]) * CC[i0].N*CC[j].N/(CC[i0].N+CC[j].N)/(CC[i0].N+CC[j].N)            # Ward s method

    for i in range(j0+1, ClustN):
        DD[i].pop(j0)
    DD.pop(j0)

    CC.pop(j0)
    ClustN -= 1

colors = [plt.cm.tab10(float(n)/ClustN) for n in range(ClustN)]
for n in range(0, ClustN):
    for i in CC[n].point:
        plt.scatter(PP[i].X, PP[i].Y, color=colors[n], s=20)
plt.show()

plt.plot(dSigma, color='b', label="dSigma")
plt.show()
