
import matplotlib.pyplot as plt
import numpy as np
from sklearn.cluster import AgglomerativeClustering
from sklearn import datasets

POINT_N = 300
CLUST_N = 3

centers = [[0.0, 0.0], [3.0, 0.0], [0.0, 3.0]]
data, targ = datasets.make_blobs(n_samples=POINT_N, centers=centers, shuffle=False, random_state=42)

res = AgglomerativeClustering(n_clusters=3, linkage='ward').fit(data)

colors = [plt.cm.tab10(float(n)/CLUST_N) for n in range(CLUST_N)]
for i in range(POINT_N):
    plt.scatter(data[i,0], data[i,1], color=colors[res.labels_[i]], s=20)
plt.show()


