import matplotlib.pyplot as plt
import numpy as np
from sklearn.model_selection import train_test_split
from sklearn.neighbors import KNeighborsClassifier

import random
from math import sqrt
from math import cos
from math import sin

CLUST_N = 2
POINT_N = 200
KNBR_N = 5

data = np.array([[0.0, 0.0] for i in range(2*POINT_N)])
targ = np.array([2 for i in range(2*POINT_N)])

for i in range(2*POINT_N):
		f = 3.14 * random.random()
		r = 0.2 * random.normalvariate(0.0, 0.4) + 0.9
		if random.random() < 0.5:
			targ[i] = 0
			data[i,0] = 0.5 + r * cos(f)
			data[i,1] = -0.25 + r * sin(f)
		else:
			targ[i] = 1
			data[i,0] = -0.5 + r * cos(f)
			data[i,1] = 0.25 - r * sin(f)


data_train, data_test, targ_train, targ_test = train_test_split(data, targ, test_size=0.5, random_state=0)

for i in range(POINT_N):
	if targ_train[i] == 0:
		plt.scatter(data_train[i,0], data_train[i,1], c='blue', marker="+")
	else:
		plt.scatter(data_train[i,0], data_train[i,1], c='green', marker="+")
	plt.scatter(data_test[i,0], data_test[i,1], s=20, c='black')
plt.show()

neigh = KNeighborsClassifier(n_neighbors=5)
neigh.fit(data_train, targ_train)
res = neigh.predict(data_test)

for i in range(POINT_N):
	if res[i] == 0:
		plt.scatter(data_test[i,0], data_test[i,1], c='blue', s=20)
	else:
		plt.scatter(data_test[i,0], data_test[i,1], c='green', s=20)
plt.show()
