
# DBSCAN from scikit_learn

import matplotlib.pyplot as plt
import numpy as np
from sklearn import metrics
from sklearn.cluster import DBSCAN

import random
from math import sqrt
from math import cos
from math import sin

CLUST_N = 2
POINT_N = 200
KNBR_N = 5

data = np.array([[0.0, 0.0] for i in range(POINT_N)])
targ = np.array([2 for i in range(POINT_N)])

for i in range(POINT_N):
		f = 3.14 * random.random()
		r = 0.2 * random.normalvariate(0.0, 0.4) + 0.9
		if random.random() < 0.5:
			targ[i] = 0
			data[i,0] = 0.5 + r * cos(f)
			data[i,1] = -0.25 + r * sin(f)
		else:
			targ[i] = 1
			data[i,0] = -0.5 + r * cos(f)
			data[i,1] = 0.25 - r * sin(f)


plt.scatter(data[:,0], data[:,1], s=20, c='black')
plt.show()

db = DBSCAN(eps=0.20, min_samples=5).fit(data)

for i in range(POINT_N):
	if db.labels_[i] == 0:
		plt.scatter(data[i,0], data[i,1], c='blue', s=20)
	else:
		if db.labels_[i] == 1:
			plt.scatter(data[i,0], data[i,1], c='green', s=20)
		else:
			plt.scatter(data[i,0], data[i,1], c='red', s=20)
plt.show()
