// simple_gdi_0.cpp

#include <windows.h>
#include <windowsx.h>

//    
LRESULT CALLBACK WindowProcedure(HWND, UINT, WPARAM, LPARAM);

//   
const TCHAR g_ctszClassName[] =
  TEXT("stu003_class_3270B424-4B34-4dcb-9931-B0E51E608AE7");
const TCHAR g_ctszAppTitle[] =
  TEXT("Simple GDI Windows App 0");

int APIENTRY WinMain(
  HINSTANCE hThisInstance, HINSTANCE hPrevInstance,
  LPSTR lpszArgument, int nCmdShow)
{
  //
  //  
  //
  WNDCLASSEX wnd_class;
  wnd_class.cbSize = sizeof (WNDCLASSEX);
  wnd_class.hInstance = hThisInstance;
  wnd_class.lpszClassName = g_ctszClassName;
  wnd_class.lpfnWndProc = WindowProcedure;
  wnd_class.style = CS_DBLCLKS;
  wnd_class.hIcon = LoadIcon(NULL, IDI_APPLICATION);
  wnd_class.hIconSm = LoadIcon(NULL, IDI_APPLICATION);
  wnd_class.hCursor = LoadCursor(NULL, IDC_ARROW);
  wnd_class.lpszMenuName = TEXT("APP_MENU");
  wnd_class.cbClsExtra = 0;
  wnd_class.cbWndExtra = 0;
  wnd_class.hbrBackground = (HBRUSH) COLOR_BACKGROUND;
  //
  //   
  //
  if (!RegisterClassEx(&wnd_class))
    return -1;
  //
  //  
  //
  HWND hWnd = CreateWindowEx(
    0,                   //   
    g_ctszClassName,     //  
    g_ctszAppTitle,
    WS_OVERLAPPEDWINDOW, //  
    CW_USEDEFAULT,       //   
    CW_USEDEFAULT,       //   
    CW_USEDEFAULT,       // 
    CW_USEDEFAULT,       // 
    HWND_DESKTOP,        //  
    NULL,                // 
    hThisInstance,       //  
    NULL);               //   
  //
  //  
  //
  ShowWindow (hWnd, nCmdShow);
  //
  //    ( GetMessage() == 0)
  //
  MSG messages;
  while (GetMessage (&messages, NULL, 0, 0))
  {
    //
    //     
    //     
    //
    TranslateMessage(&messages);
    //
    //    WindowProcedure()
    //
    DispatchMessage(&messages);
  }
  //
  //   ,  PostQuitMessage()
  //
  return messages.wParam;
}

//
//      DispatchMessage()
//
LRESULT CALLBACK WindowProcedure(
  HWND hWnd, UINT uMesage, WPARAM wParam, LPARAM lParam)
{
  switch (uMesage)
  {
    case WM_COMMAND:
      switch (wParam)
      {
        case 1:
          SendMessage(hWnd, WM_CLOSE, 0, 0);
          break;
        case 2:
          MessageBox(
            hWnd, TEXT("  ->  ..."),
            g_ctszAppTitle, MB_OK);
          break;
      }
      break;
    case WM_PAINT:
    {
      //   
      PAINTSTRUCT paint_s;
      HDC hDC = BeginPaint(hWnd, &paint_s);
      //  
      TextOut(hDC, 10, 20, TEXT(" WM_PAINT"), 18);
      //   
      EndPaint(hWnd, &paint_s);
      break;
    }
    case WM_LBUTTONDOWN:
    {
      //    
      HDC hDC = GetDC(hWnd);
      //   
      TextOut(
        hDC, 10, 40, TEXT(" WM_LBUTTONDOWN"), 24);
      //    
      ReleaseDC(hWnd, hDC);
      break;
    }
    case WM_MOUSEMOVE:
    {
      if (wParam & MK_LBUTTON && wParam & MK_SHIFT)
      {
        int nX = GET_X_LPARAM(lParam);    //  windowsx.h
        int nY = GET_Y_LPARAM(lParam);
        HDC hDC = GetDC(hWnd);
        SetPixel(hDC, nX, nY, RGB(0, 0, 0));
        ReleaseDC(hWnd, hDC);
      }
      break;
    }
    case WM_CLOSE:
    {
      int nAnswer = MessageBox(
        hWnd,
        TEXT(" ,    ?"),
        TEXT(""), MB_YESNO | MB_ICONEXCLAMATION);
      if (nAnswer == IDYES)
        return DefWindowProc(hWnd, uMesage, wParam, lParam);
      break;
    }
    case WM_DESTROY:
      PostQuitMessage(0);       //  WM_QUIT  
      break;
    default:    //     
      return DefWindowProc(hWnd, uMesage, wParam, lParam);
  }
  //
  return 0;
}

//  
