// simple_gdi_3.cpp

#include <windows.h>

const TCHAR g_ctszClassName[] =
  TEXT("stu003_class_C54FABF7-5534-41b4-9CB0-143BE1348BC7");
const TCHAR g_ctszAppTitle[] =
  TEXT("Simple GDI Windows App 3");

LRESULT CALLBACK WindowProcedure(
  HWND hWnd, UINT uMesage, WPARAM wParam, LPARAM lParam);

int APIENTRY WinMain(
  HINSTANCE hThisInstance,
  HINSTANCE hPrevInstance,
  LPSTR lptszCmdLine,
  int nCmdShow)
{
  WNDCLASSEX wnd_class;
  wnd_class.cbSize = sizeof (WNDCLASSEX);
  wnd_class.style = CS_HREDRAW | CS_VREDRAW;
  wnd_class.lpfnWndProc = WindowProcedure;
  wnd_class.cbClsExtra = 0;
  wnd_class.cbWndExtra = 0;
  wnd_class.hInstance = hThisInstance;
  wnd_class.hIcon = LoadIcon(NULL, IDI_APPLICATION);
  wnd_class.hCursor = LoadCursor(NULL, IDC_ARROW);
  wnd_class.hbrBackground = CreateSolidBrush(RGB(255, 255, 255));
  wnd_class.lpszMenuName = NULL,
  wnd_class.lpszClassName = g_ctszClassName;
  wnd_class.hIconSm = LoadIcon(NULL, IDI_APPLICATION);
  //
  if (!RegisterClassEx(&wnd_class))
    return -1;
  //
  HWND hWnd = CreateWindowEx(
    0,                   //   
    g_ctszClassName,     //  
    g_ctszAppTitle,
    WS_OVERLAPPEDWINDOW, //  
    CW_USEDEFAULT,       //   
    CW_USEDEFAULT,       //   
    CW_USEDEFAULT,       // 
    CW_USEDEFAULT,       // 
    HWND_DESKTOP,        //  
    NULL,                // 
    hThisInstance,       //  
    NULL);               //   
  //
  ShowWindow (hWnd, nCmdShow);
  //
  MSG messages;
  while (GetMessage (&messages, NULL, 0, 0))
  {
    DispatchMessage(&messages);
  }
  //
  return messages.wParam;
}    // WinMain()

LRESULT CALLBACK WindowProcedure(
  HWND hWnd, UINT uMesage, WPARAM wParam, LPARAM lParam)
{
  switch (uMesage)
  {
    case WM_PAINT:
    {
      PAINTSTRUCT paint_s;
      HDC hDC = BeginPaint(hWnd, &paint_s);
      //
      RECT rect;
      GetClientRect(hWnd, &rect);
      SetMapMode(hDC, MM_ISOTROPIC);
      SetWindowExtEx(hDC, 1000, 1000, NULL);
      SetViewportOrgEx(hDC, rect.right / 2, rect.bottom / 2, NULL);
      SetViewportExtEx(hDC, rect.right, - rect.bottom, NULL);
      //
      SelectObject(hDC, GetStockObject(BLACK_PEN));
      SelectObject(hDC, GetStockObject(NULL_BRUSH));
      //
      LOGFONT font = { 240, 0 };
      font.lfCharSet = RUSSIAN_CHARSET;
      lstrcpy(font.lfFaceName, TEXT("Arial"));
      HFONT hFont = CreateFontIndirect(&font);
      HGDIOBJ hFontOld = SelectObject(hDC, (HGDIOBJ) hFont);
      //
      TCHAR tszText[] = TEXT("  ");
      SIZE sizeB;
      GetTextExtentPoint32(hDC, tszText, 15, &sizeB);
      RECT rectB =
      {
        -sizeB.cx / 2,  sizeB.cy / 2,
         sizeB.cx / 2, -sizeB.cy / 2
      };
      DrawText(
        hDC, tszText, -1, &rectB,
        DT_CENTER | DT_VCENTER | DT_NOCLIP | DT_SINGLELINE |
        DT_CALCRECT);
      DrawText(
        hDC, tszText, -1, &rectB,
        DT_CENTER | DT_VCENTER | DT_NOCLIP | DT_SINGLELINE );
      Rectangle(
        hDC, rectB.left - 20, rectB.top + 20,
        rectB.right + 20, rectB.bottom - 20);
      //
      SelectObject(hDC, hFontOld);
      DeleteObject(hFont);
      //
      EndPaint(hWnd, &paint_s);
      break;
    }
    case WM_DESTROY:
      PostQuitMessage(0);       //  WM_QUIT  
      break;
    default:    //     
      return DefWindowProc(hWnd, uMesage, wParam, lParam);
  }    // switch (uMesage)
  //
  return 0;
}    // WindowProcedure()

//  
