// simple_gdi_1.cpp

#include <windows.h>

const TCHAR g_ctszClassName[] =
  TEXT("stu003_class_A2E5A44E-15DE-45F4-A1D8-F27A8AEF9714");
const TCHAR g_ctszAppTitle[] =
  TEXT("Simple GDI Windows App 1");

LRESULT CALLBACK WindowProcedure(
  HWND hWnd, UINT uMesage, WPARAM wParam, LPARAM lParam);

int APIENTRY WinMain(
  HINSTANCE hThisInstance,
  HINSTANCE hPrevInstance,
  LPSTR lptszCmdLine,
  int nCmdShow)
{
  WNDCLASSEX wnd_class;
  wnd_class.cbSize = sizeof (WNDCLASSEX);
  wnd_class.style = CS_HREDRAW | CS_VREDRAW;
  wnd_class.lpfnWndProc = WindowProcedure;
  wnd_class.cbClsExtra = 0;
  wnd_class.cbWndExtra = 0;
  wnd_class.hInstance = hThisInstance;
  wnd_class.hIcon = LoadIcon(NULL, IDI_APPLICATION);
  wnd_class.hCursor = LoadCursor(NULL, IDC_ARROW);
  wnd_class.hbrBackground = CreateSolidBrush(RGB(255, 255, 255));
  wnd_class.lpszMenuName = NULL,
  wnd_class.lpszClassName = g_ctszClassName;
  wnd_class.hIconSm = LoadIcon(NULL, IDI_APPLICATION);
  //
  if (!RegisterClassEx(&wnd_class))
    return -1;
  //
  HWND hWnd = CreateWindowEx(
    0,                   //   
    g_ctszClassName,     //  
    g_ctszAppTitle,
    WS_OVERLAPPEDWINDOW, //  
    CW_USEDEFAULT,       //   
    CW_USEDEFAULT,       //   
    CW_USEDEFAULT,       // 
    CW_USEDEFAULT,       // 
    HWND_DESKTOP,        //  
    NULL,                // 
    hThisInstance,       //  
    NULL);               //   
  //
  ShowWindow (hWnd, nCmdShow);
  //
  MSG messages;
  while (GetMessage (&messages, NULL, 0, 0))
  {
    DispatchMessage(&messages);
  }
  //
  return messages.wParam;
}    // WinMain()

LRESULT CALLBACK WindowProcedure(
  HWND hWnd, UINT uMesage, WPARAM wParam, LPARAM lParam)
{
  switch (uMesage)
  {
    case WM_PAINT:
    {
      PAINTSTRUCT paint_s;
      HDC hDC = BeginPaint(hWnd, &paint_s);
      //
      RECT rect;
      GetClientRect(hWnd, &rect);
      SetMapMode(hDC, MM_ISOTROPIC);
      SetWindowExtEx(hDC, 1000, 1000, NULL);
      SetViewportOrgEx(hDC, rect.right / 2, rect.bottom / 2, NULL);
      SetViewportExtEx(hDC, rect.right, - rect.bottom, NULL);
      //
      SelectObject(hDC, GetStockObject(BLACK_PEN));
      SelectObject(hDC, GetStockObject(NULL_BRUSH));
      //
      for (int i = 50; i < 500; i += 50)
        Ellipse(hDC, -i, -i, i, i);
      //
      EndPaint(hWnd, &paint_s);
      break;
    }
    case WM_DESTROY:
      PostQuitMessage(0);       //  WM_QUIT  
      break;
    default:    //     
      return DefWindowProc(hWnd, uMesage, wParam, lParam);
  }    // switch (uMesage)
  //
  return 0;
}    // WindowProcedure()

//  
