// simple_gdi_4.cpp

#include <windows.h>

const TCHAR g_ctszClassName[] =
  TEXT("stu003_class_8898F575-6ECF-4454-AB02-A3172289EC4D");
const TCHAR g_ctszWindowName[] =
  TEXT("Memory context example");

LRESULT CALLBACK WindowProcedure(
  HWND hWnd,
  UINT uMsg,
  WPARAM wParam,
  LPARAM lParam);

int APIENTRY WinMain(
  HINSTANCE hInstance,
  HINSTANCE hPrevInstance,
  LPSTR lptszCmdLine,
  int nCmdShow)
{
  WNDCLASSEX wnd_class;
  wnd_class.cbSize = sizeof (WNDCLASSEX);
  wnd_class.style = CS_HREDRAW | CS_VREDRAW;
  wnd_class.lpfnWndProc = WindowProcedure;
  wnd_class.cbClsExtra = 0;
  wnd_class.cbWndExtra = 0;
  wnd_class.hInstance = hInstance;
  wnd_class.hIcon = LoadIcon(NULL, IDI_APPLICATION);
  wnd_class.hCursor = LoadCursor(NULL, IDC_ARROW);
  wnd_class.hbrBackground = (HBRUSH) NULL;
  wnd_class.lpszMenuName = NULL;
  wnd_class.lpszClassName = g_ctszClassName;
  wnd_class.hIconSm = LoadIcon(NULL, IDI_APPLICATION);
  //
  if (!RegisterClassEx(&wnd_class))
    return -1;
  //
  HWND hWnd = CreateWindow(
    g_ctszClassName,            // lpctszClassName
    g_ctszWindowName,           // lpctszWindowName
    WS_OVERLAPPEDWINDOW,        // dwStyle
    CW_USEDEFAULT,              // nX
    CW_USEDEFAULT,              // nY
    CW_USEDEFAULT,              // nWidth
    CW_USEDEFAULT,              // nHeight
    NULL,                       // hWndParent
    NULL,                       // hMenu
    hInstance,                  // hInstance
    NULL);                      // lpParam
  //
  ShowWindow(hWnd, nCmdShow);
  //
  MSG messages;
  while (GetMessage(&messages, NULL, 0, 0))
    DispatchMessage(&messages);
  //
  return messages.lParam;
  //
}    // WinMain()

LRESULT CALLBACK WindowProcedure(
  HWND hWnd,
  UINT uMsg,
  WPARAM wParam,
  LPARAM lParam)
{
  static HDC s_hWindowDC = NULL;
  static HDC s_hMemDC = NULL;
  switch (uMsg)
  {
    case WM_CREATE:
    {
      s_hWindowDC = GetDC(hWnd);
      s_hMemDC = CreateCompatibleDC(s_hWindowDC);
      //
      break;
    }
    case WM_SIZE:
    {
      WORD wWidth = LOWORD(lParam);
      WORD wHeight = HIWORD(lParam);
      HBITMAP hBitmap = CreateCompatibleBitmap(
        s_hWindowDC, wWidth, wHeight);
      HGDIOBJ hObject = SelectObject(s_hMemDC, hBitmap);
      DeleteObject(hObject);
      //
      RECT rect = { 0, 0, wWidth, wHeight };
      FillRect(s_hMemDC, &rect, (HBRUSH) RGB(255, 255, 255));
      //
      const int cnDWidth = wWidth / 22;
      const int cnDHeight = wHeight / 22;
      int nLeft = 0;
      int nTop = 0;
      int nRight = wWidth;
      int nBotom = wHeight;
      int nR = 0;
      int nG = 100;
      int nB = 255;
      for (int i = 0; i < 10; ++ i)
      {
        nLeft += cnDWidth;
        nTop += cnDHeight;
        nRight -= cnDWidth;
        nBotom -= cnDHeight;
        nR += 25;
        nG += 10;
        nB -= 25;
        //
        HPEN hPen = CreatePen(PS_SOLID, 0, RGB(nR, nG, nB));
        HGDIOBJ hOldPen = SelectObject(s_hMemDC, hPen);
        DeleteObject(hOldPen);
        //
        Rectangle(
          s_hMemDC, nLeft, nTop, nRight, nBotom);
        //
      }    // for (int i = 0; i < 10; ++ i)
      //
      break;
      //
    }    // case WM_SIZE
    case WM_PAINT:
    {
      PAINTSTRUCT paint_s;
      HDC hDC = BeginPaint(hWnd, &paint_s);
      //
      RECT rect;
      GetClientRect(hWnd, &rect);
      //
      BitBlt(
        hDC,                    // hDCDest
        0,                      // nXDest
        0,                      // nYDest
        rect.right,             // nWidth
        rect.bottom,            // nHeight
        s_hMemDC,               // hDCSrc
        0,                      // nXSrc
        0,                      // nYSrc
        SRCCOPY);               // dwRop
      //
      EndPaint(hWnd, &paint_s);
      //
      break;
      //
    }    // case WM_PAINT
    case WM_DESTROY:
      //
      PostQuitMessage(0);
      //
      break;
      //
    default:
      //
      return DefWindowProc(hWnd, uMsg, wParam, lParam);
  }
  //
  return 0;
  //
}    // WindowProcedure()

//  
