// simple_gdi_2.cpp

#include <windows.h>

const TCHAR g_ctszClassName[] =
  TEXT("stu003_class_FEBD9A80-9E75-4e14-9E87-AC9ED1325F9B");
const TCHAR g_ctszAppTitle[] =
  TEXT("Simple GDI Windows App 2");

LRESULT CALLBACK WindowProcedure(
  HWND hWnd, UINT uMesage, WPARAM wParam, LPARAM lParam);

int APIENTRY WinMain(
  HINSTANCE hThisInstance,
  HINSTANCE hPrevInstance,
  LPSTR lptszCmdLine,
  int nCmdShow)
{
  WNDCLASSEX wnd_class;
  wnd_class.cbSize = sizeof (WNDCLASSEX);
  wnd_class.style = CS_HREDRAW | CS_VREDRAW;
  wnd_class.lpfnWndProc = WindowProcedure;
  wnd_class.cbClsExtra = 0;
  wnd_class.cbWndExtra = 0;
  wnd_class.hInstance = hThisInstance;
  wnd_class.hIcon = LoadIcon(NULL, IDI_APPLICATION);
  wnd_class.hCursor = LoadCursor(NULL, IDC_ARROW);
  wnd_class.hbrBackground = CreateSolidBrush(RGB(255, 255, 255));
  wnd_class.lpszMenuName = NULL,
  wnd_class.lpszClassName = g_ctszClassName;
  wnd_class.hIconSm = LoadIcon(NULL, IDI_APPLICATION);
  //
  if (!RegisterClassEx(&wnd_class))
    return -1;
  //
  HWND hWnd = CreateWindowEx(
    0,                   //   
    g_ctszClassName,     //  
    g_ctszAppTitle,
    WS_OVERLAPPEDWINDOW, //  
    CW_USEDEFAULT,       //   
    CW_USEDEFAULT,       //   
    CW_USEDEFAULT,       // 
    CW_USEDEFAULT,       // 
    HWND_DESKTOP,        //  
    NULL,                // 
    hThisInstance,       //  
    NULL);               //   
  //
  ShowWindow (hWnd, nCmdShow);
  //
  MSG messages;
  while (GetMessage (&messages, NULL, 0, 0))
  {
    DispatchMessage(&messages);
  }
  //
  return messages.wParam;
}    // WinMain()

LRESULT CALLBACK WindowProcedure(
  HWND hWnd, UINT uMesage, WPARAM wParam, LPARAM lParam)
{
  switch (uMesage)
  {
    case WM_PAINT:
    {
      PAINTSTRUCT paint_s;
      HDC hDC = BeginPaint(hWnd, &paint_s);
      //
      RECT rect;
      GetClientRect(hWnd, &rect);
      SetMapMode(hDC, MM_ISOTROPIC);
      SetWindowExtEx(hDC, 1000, 1000, NULL);
      SetViewportOrgEx(hDC, rect.right / 2, rect.bottom / 2, NULL);
      SetViewportExtEx(hDC, rect.right, - rect.bottom, NULL);
      //
      SelectObject(hDC, GetStockObject(BLACK_PEN));
      SelectObject(hDC, GetStockObject(BLACK_BRUSH));
      //
      MoveToEx(hDC, -490, 0, NULL);
      LineTo(hDC, 490, 0);
      MoveToEx(hDC, 0, -490, NULL);
      LineTo(hDC, 0, 490);
      //
      const POINT caArrowH[] =
      {
        { 490, 0 }, { 440, -10 }, { 440, 10 }
      };
      //
      Polygon(hDC, caArrowH, 3);
      //
      const POINT caArrowV[] =
      {
        { 0, 490 }, { -10, 440 }, { 10,  440 }
      };
      //
      Polygon(hDC, caArrowV, 3);
      //
      TCHAR tszStart[] = TEXT("(0, 0)");
      TCHAR tszStopX[] = TEXT("(Xmax, 0)");
      TCHAR tszStopY[] = TEXT("(0, Ymax)");
      //
      RECT rectS = { -10,   0,   0, -10 };
      RECT rectX = { 430,   0, 440, -10 };
      RECT rectY = {   0, 430, -10, 440 };
      //
      SetBkMode(hDC, TRANSPARENT);
      DrawText(
        hDC, tszStart, -1, &rectS, DT_NOCLIP | DT_RIGHT | DT_TOP);
      DrawText(
        hDC, tszStopX, -1, &rectX, DT_NOCLIP | DT_RIGHT | DT_TOP);
      DrawText(
        hDC, tszStopY, -1, &rectY, DT_NOCLIP | DT_RIGHT | DT_TOP);
      //
      EndPaint(hWnd, &paint_s);
      break;
    }
    case WM_DESTROY:
      PostQuitMessage(0);       //  WM_QUIT  
      break;
    default:    //     
      return DefWindowProc(hWnd, uMesage, wParam, lParam);
  }    // switch (uMesage)
  //
  return 0;
}    // WindowProcedure()

//  
