// using_dynamic.cpp

#include <iostream>

#include <windows.h>

int main()
{
  HMODULE hLib = LoadLibrary(TEXT("with_def.dll"));
  if (hLib == NULL)
  {
    std::cerr << "Error loading with_def" << std::endl;
    return 1;
  }
  //
  typedef void (*PFN_SOME_FUNC)(LPCTSTR);
  typedef int (*PFN_YET_FUNC)(int);
  //
  PFN_SOME_FUNC pfnSomeFunc =
    (PFN_SOME_FUNC) GetProcAddress(hLib, "SomeFunction");
  if (pfnSomeFunc == NULL)
  {
    std::cerr << "Could not find SomeFunction" << std::endl;
    FreeLibrary(hLib);
    return 1;
  }
  //
  PFN_YET_FUNC pfnYetFunc =
    (PFN_YET_FUNC) GetProcAddress(hLib, MAKEINTRESOURCE(3));
  if (pfnYetFunc == NULL)
  {
    std::cerr << "Could not find 3-rd function" << std::endl;
    FreeLibrary(hLib);
    return 1;
  }
  //
  (*pfnSomeFunc)(TEXT("Test dynamic loading"));
  //
  int n = (*pfnYetFunc)(4);
  std::cout << n << std::endl;
  //
  FreeLibrary(hLib);
}

//  
