// srv_program.cpp

#include <windows.h>
#include <tchar.h>

#include <iostream>
#include <cstdio>
#include <cstdlib>

using namespace std;

TCHAR g_tszServiceName[] = _T("My Dummy Server");
SERVICE_STATUS g_SeviceStatus;
SERVICE_STATUS_HANDLE g_hServiceStatusHandle;
HANDLE g_hServiceStopEvent = NULL;

void MySvcError(LPCTSTR lpctszFunction)
{
  HANDLE hEventSource = RegisterEventSource(
    NULL, g_tszServiceName);
  if (NULL == hEventSource)
    return;
  //
  static TCHAR s_tszBuffer[1000];
  _sntprintf(
    s_tszBuffer,
    sizeof (s_tszBuffer),
    _T("%s() failed with %d"),
    lpctszFunction,
    GetLastError());
  LPCTSTR alpszStrings[] =
  {
    g_tszServiceName,
    s_tszBuffer
  };
  //
  ReportEvent(
    hEventSource,        //  
    EVENTLOG_ERROR_TYPE, //  
    0,                   //  
    999,                 //  
    NULL,                //  
    2,                   //  alpszStrings
    0,                   //   
    alpszStrings,        //  
    NULL);               //   
  //
  DeregisterEventSource(hEventSource);
}    // MySvcError()

SC_HANDLE MyOpenSCManager()
{
  SC_HANDLE schManager = OpenSCManager(
    NULL,                    //  
    NULL,                    //  ServicesActive
    SC_MANAGER_ALL_ACCESS);  //  
  if (NULL == schManager)
  {
    cerr << "OpenSCManager() failed: " << GetLastError() << endl;
    exit(1);
  }
  return schManager;
}    // MyOpenSCManager()

void MySvcInstall()
{
  static TCHAR s_tszModulePath[65536];
  DWORD dwResult = GetModuleFileName(
    NULL, s_tszModulePath,
    sizeof (s_tszModulePath) / sizeof (TCHAR));
  if (0 == dwResult)
  {
    cerr << "Cannot get the module path: " << GetLastError() << endl;
    return;
  }
  //
  SC_HANDLE schManager = MyOpenSCManager();
  //
  SC_HANDLE schService = CreateService(
    schManager,                //  SCM
    g_tszServiceName,          //  
    g_tszServiceName,          //  
    SERVICE_ALL_ACCESS,        //  
    SERVICE_WIN32_OWN_PROCESS, //  
    SERVICE_DEMAND_START,      //  
    SERVICE_ERROR_NORMAL,      //   
    s_tszModulePath,           //   
    NULL,                      //   
    NULL,                      //   
    NULL,                      // 
    NULL,                      //   LocalSystem
    NULL);                     // 
  //
  if (NULL == schService)
  {
    cerr << "CreateService() failed: " << GetLastError() << endl;
    CloseServiceHandle(schManager);
    return;
  }
  //
  cout << g_tszServiceName << " installed successfully" << endl;
  CloseServiceHandle(schService);
  CloseServiceHandle(schManager);
}    // MySvcInstall()

void MySvcUninstall()
{
  SC_HANDLE schManager = MyOpenSCManager();
  SC_HANDLE schService = OpenService(
    schManager,
    g_tszServiceName,
    SC_MANAGER_ALL_ACCESS);
  if (NULL == schService)
  {
    cerr << "OpenService() failed: " << GetLastError() << endl;
    CloseServiceHandle(schManager);
    return;
  }
  //
  BOOL bSuccess = DeleteService(schService);
  if (bSuccess)
    cout << g_tszServiceName << " uninstalled successfully" << endl;
  else
    cerr << "DeleteService() failed: " << GetLastError() << endl;
  //
  CloseServiceHandle(schService);
  CloseServiceHandle(schManager);
}    // MySvcUninstall()

void MySvcReport(
  DWORD dwCurrentState, DWORD dwWin32ExitCode, DWORD dwWaitHint)
{
  static DWORD dwCheckPoint = 1;
  //
  g_SeviceStatus.dwCurrentState = dwCurrentState;
  g_SeviceStatus.dwWin32ExitCode = dwWin32ExitCode;
  g_SeviceStatus.dwWaitHint = dwWaitHint;
  g_SeviceStatus.dwControlsAccepted =
    dwCurrentState == SERVICE_START_PENDING ?
    0 : SERVICE_ACCEPT_STOP;
  g_SeviceStatus.dwCheckPoint =
    dwCurrentState == SERVICE_RUNNING ||
    dwCurrentState == SERVICE_STOPPED ?
    0 : dwCheckPoint ++;
  //
  SetServiceStatus(
    g_hServiceStatusHandle,
    &g_SeviceStatus);
}    // MySvcReport()

DWORD WINAPI MySvcCtrlHandlerEx(
  DWORD dwControl, DWORD dwEventType,
  LPVOID lpvEventData, LPVOID lpvContext)
{
  switch (dwControl)
  {
    case SERVICE_CONTROL_STOP:
      //
      MySvcReport(SERVICE_STOP_PENDING, NO_ERROR, 0);
      SetEvent(g_hServiceStopEvent);
      MySvcReport(g_SeviceStatus.dwCurrentState, NO_ERROR, 0);
      return NO_ERROR;
      //
    case SERVICE_CONTROL_INTERROGATE:
      //
      return NO_ERROR;
  }    // switch (dwControl)
  //
  return ERROR_CALL_NOT_IMPLEMENTED;
}    // MySvcCtrlHandler()

VOID WINAPI MySvcMain(DWORD dwArgc, LPTSTR *plpszArgv)
{
  g_hServiceStatusHandle = RegisterServiceCtrlHandlerEx(
    g_tszServiceName,
    &MySvcCtrlHandlerEx,
    NULL);
  //
  if (0 == g_hServiceStatusHandle)
  {
    MySvcError(_T("RegisterServiceCtrlHandlerEx"));
    return;
  }
  //
  g_SeviceStatus.dwServiceType = SERVICE_WIN32_OWN_PROCESS;
  g_SeviceStatus.dwServiceSpecificExitCode = 0;
  //
  MySvcReport(SERVICE_START_PENDING, NO_ERROR, 3000);
  //
  //    
  //
  g_hServiceStopEvent = CreateEvent(
    NULL,     //    
    TRUE,     //  
    FALSE,    //  
    NULL);    //  
  //
  if (NULL == g_hServiceStopEvent)
  {
    MySvcReport(SERVICE_STOPPED, NO_ERROR, 0);
    return;
  }
  //
  MySvcReport(SERVICE_RUNNING, NO_ERROR, 0);
  WaitForSingleObject(g_hServiceStopEvent, INFINITE);
  MySvcReport(SERVICE_STOPPED, NO_ERROR, 0);
}    // MySvcMain()

int main(int nArgC, char *apszArgV[])
{
  if (nArgC > 1)
  {
    if (lstrcmpiA(apszArgV[1], "install") == 0)
    {
      MySvcInstall();
      return 0;
    }
    if (lstrcmpiA(apszArgV[1], "uninstall") == 0)
    {
      MySvcUninstall();
      return 0;
    }
  }    // if (nArgC > 1)
  //
  SERVICE_TABLE_ENTRY aDispatchTable[] =
  {
    {
      g_tszServiceName,
      &MySvcMain
    },
    {
      NULL,
      NULL
    }
  };
  //
  BOOL bSuccess = StartServiceCtrlDispatcher(aDispatchTable);
  //
  //    
  //
  if (!bSuccess)
    if (GetLastError() ==
      ERROR_FAILED_SERVICE_CONTROLLER_CONNECT)
      cerr << "Running as an application" << endl;
    else
      MySvcError(_T("StartServiceCtrlDispatcher"));
}    // main()

//  
