﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;

namespace Graphic1
{
  public partial class Form1 : Form
  {
    Painter p;
  
    public Form1()
    {  
      InitializeComponent();
      //  Создаем объект класса Painter - он нам понадобится для хранения
      //  координат текущей точки, что позволит реализовать аналоги методов
      //  LineTo и MoveTo
      p = new Painter();
    }

    /// <summary>
    /// Сохранение изображения в файл
    /// </summary>
    /// <param name="sender"></param>
    /// <param name="e"></param>
    private void saveButton_Click(object sender, EventArgs e)
    {
      //  Если нет изображения, то и сохранять нечего, выходим  
      if (pctBox1.Image == null)
        return;
  
      //  Явно определяем диалог для сохранения изображения
      SaveFileDialog saveDlg = new SaveFileDialog();
        
      //  Открываем файлы из папки приложения
      saveDlg.InitialDirectory = Environment.CurrentDirectory;
        
      //  В качестве фильтра используем строку, определенную в файле 
      //  ресурсов. Использовать ее можно так:
      saveDlg.Filter = Graphic1.Properties.Resources.DlgFilterString;
        
      //  По умолчанию работаем с bmp, поэтому устанавливаем соответствующее
      //  значение активного фильтра
      saveDlg.FilterIndex = 2;
        
      //  После закрытия диалога восстанавливаем исходную текущую директорию
      saveDlg.RestoreDirectory = true;
        
      //  Определяем заголовок диалога
      saveDlg.Title = "Сохранить изображение как...";
        
      //  Показываем диалог, и если сохранение подтверждено, сохраняем файл
      if (saveDlg.ShowDialog() == DialogResult.OK)
        pctBox1.Image.Save(saveDlg.FileName);
          
      return;
    }

    private void pctBox1_Paint(object sender, PaintEventArgs e)
    {
      if (pctBox1.Image != null)
      {
        toolStripSizeInfoLbl.Text = "Размер изображения: " + pctBox1.Image.Width.ToString() + "x" + pctBox1.Image.Height.ToString();
      }
      else
      {
        toolStripSizeInfoLbl.Text = "Нет изображения";
      }
    }

    private void gradientButton_Click(object sender, EventArgs e)
    {
      //  Получаем Bitmap с градиентом
      pctBox1.Image = Painter.Gradient(pctBox1.Width, pctBox1.Height);
    }

    private void openButton_Click(object sender, EventArgs e)
    {
      OpenFileDialog openDlg = new OpenFileDialog();

      openDlg.InitialDirectory = Environment.CurrentDirectory;
      //openDlg.Filter = "Изображение в формате PNG (*.png)|*.png";
      //  saveFileDialog1.FilterIndex = filterIndex;
      openDlg.RestoreDirectory = true;
      openDlg.Title = "Открыть изображение как...";
      if (openDlg.ShowDialog() == DialogResult.OK)
        try
        {
          pctBox1.Image = new Bitmap(openDlg.FileName);
        }
        catch
        {
          MessageBox.Show("Не могу открыть изображение.");
        }
      p.MoveTo(0, 0);
      return;
    }

    private void newButton_Click(object sender, EventArgs e)
    {
      pctBox1.Image = new Bitmap(pctBox1.Width, pctBox1.Height);
        
      Graphics g = Graphics.FromImage(pctBox1.Image);
        
      g.FillRectangle(new SolidBrush(Color.White), 0, 0, pctBox1.Width, pctBox1.Height);

      p.MoveTo(0, 0);
    }

    private void pctBox1_MouseMove(object sender, MouseEventArgs e)
    {
      toolStripInfoLbl.Text = "Курсор мыши: " + e.X.ToString() + ";" + e.Y.ToString() + 
      "   Текущая точка :" +p.curentPos();
      if (e.Button == MouseButtons.Right)
        p.MoveTo(e.X, e.Y);
      if (e.Button == MouseButtons.Left)
        pctBox1.Image = p.LineTo(pctBox1.Image, e.X, e.Y);
    }

    private void clearInfoLbl(object sender, EventArgs e)
    {
      toolStripInfoLbl.Text = "";
    }

    private void openButton_MouseEnter(object sender, EventArgs e)
    {
      toolStripInfoLbl.Text = "Открыть существующее изображение";
    }

    private void newButton_MouseEnter(object sender, EventArgs e)
    {
      toolStripInfoLbl.Text = "Создать новое изображение";
    }

    private void SaveButton_MouseEnter(object sender, EventArgs e)
    {
      toolStripInfoLbl.Text = "Сохранить изображение";
    }

    private void gradientButton_MouseEnter(object sender, EventArgs e)
    {
      toolStripInfoLbl.Text = "Градиентная заливка всего изображения";
    }

    private void button1_Click(object sender, EventArgs e)
    {
      //  Квадратики золотистые рисуем
      pctBox1.Image = Painter.Squares(pctBox1.Image);
    }

    private void pctBox1_MouseDown(object sender, MouseEventArgs e)
    {
      //  При нажатии клавиши просто переходим в эту точку, чтобы 
      //  дальше рисовать кривую из этой точки
      p.MoveTo(e.X, e.Y);
    }

    private void sqrButton_MouseEnter(object sender, EventArgs e)
    {
      toolStripInfoLbl.Text = "Рисование золотистых квадратиков";
    }

    private void pctBox1_SizeChanged(object sender, EventArgs e)
    {
      //  Как-то надо изменять размеры изображения, не стирая уже 
      //  нарисованного
      pctBox1.Image = new Bitmap(pctBox1.Image, pctBox1.Width, pctBox1.Height);
    }
  }
}
