﻿using System;
using System.Drawing;

using System.Windows.Forms;

public class Painter
{
  //  Координаты текущей точки на канве
  int x, y;
  
  public Painter()
	{
    //  Определяем текущую точку
    x = 0; y = 0;
	}
  
  /// <summary>
  /// Возвращает текущую точку в виде строки
  /// </summary>
  /// <returns>Координаты текущей точки</returns>
  public string curentPos()
  {
    return x.ToString() + ";" + y.ToString();
  }

  /// <summary>
  /// Перемещение текущей точки в точку с координатами x, y
  /// </summary>
  /// <param name="x"></param>
  /// <param name="y"></param>
  public void MoveTo(int x, int y)
  {
    this.x = x; this.y = y;
  }

  /// <summary>
  /// Рисование линии на Image img темно-синим цветом из текущей точки 
  /// в точку с координатами x, y
  /// </summary>
  /// <param name="img"></param>
  /// <param name="x"></param>
  /// <param name="y"></param>
  /// <returns></returns>
  public Image LineTo(Image img, int x, int y)
  {
    //  Если нет изображения, то ничего не делать
    if(img==null) return null;
    
    try
    {
      //  Создаем новый объект Graphics
      Graphics g = Graphics.FromImage(img);
      //  Линия
      g.DrawLine(new Pen(Color.DarkBlue), this.x, this.y, x, y);
      //  Меняем координаты текущей точки
      this.x = x; this.y = y;
      //  Возвращаем измененное изображение
      return img;
    }
    catch
    {
      MessageBox.Show("Непредвиденная ошибка");
    };
    return null;
  }

  /// <summary>
  /// Рисование квадратов золотистым цветом
  /// </summary>
  /// <returns>Bitmap с нарисованными квадратами</returns>
  public static Bitmap Squares(Image img)
  {
    //  Если изображение отсутствует - выход
    if (img == null) return null;

    //  Создаем массив Bitmap - матрицу битовую
    Bitmap bmp = new Bitmap(img);
    
    //  Класс graphics - реализует средства рисования
    Graphics g = Graphics.FromImage(bmp);

    //  В цикле рисуем прямоугольники
    for (int i = 0; i < img.Width - 10; i += 30)
      for (int j = 0; j < img.Height - 10; j += 30)
        g.DrawRectangle(new Pen(Color.Goldenrod), i, j, 10, 10);
    
    return bmp;
  }

  /// <summary>
  /// Возвращает объект класса Bitmap с градиентной заливкой
  /// </summary>
  /// <returns>Возвращает false в случае отсутствующего изображения, иначе true</returns>
  public static Bitmap Gradient(int Wdth, int Hght)
  {
    //  Если изображения нет, то ничего не делаем
    if (Wdth<=0 || Hght<=0) return null;

    //  Создаем новый объект класса Bitmap
    Bitmap bmp = new Bitmap(Wdth, Hght);

    //  Проходим по точкам, заливаем 
    for (int i = 0; i < Wdth; i++)
      for (int j = 0; j < Hght; j++)
        bmp.SetPixel(i, j, Color.FromArgb(i*256/Wdth, j*256/Hght, 100));
    
    //  Возвращаем объект Bitmap с нарисованным градиентом
    return bmp;
  }
}
